<# 
Beherenbestanden.ps1

Programma om bestanden in studentmappen te beheren, dus bestanden klaarzetten, backuppen, verplaatsen of wissen.

Zie voor versienummer onder "Declareren variabelen".

Versienummer wordt volgens Semantic Versioning uitgevoerd (zie https://Semver.org)

Dit programma is beschermt met auteursplicht door middel van de GNU GPL (https://www.gnu.org/licenses)

Lees ook de readme.txt op https://beherenbestanden.neveshuis.nl/readme.txt
#>

write-host ""
write-host "** Programma Beherenbestanden is opgestart **" -f Green
write-host ""

# zoeken naar update voor pnp.powereshell uitzetten
$env:pnppowershell_updatecheck = 'off'

# toevoegen .NET framework klassen ---------------------------------------------------------
Add-Type -AssemblyName PresentationFramework
Add-Type -AssemblyName System.Drawing
Add-Type -AssemblyName System.Windows.Forms

<# manier om console af te sluiten en weer te openen. Het sluiten wordt uitgevoerd voor het starten van de hoofdscherm.
   Onderstaande klasse en 2 functions, ShowConsole en HideConsole, zijn hiervoor nodig.
#>
Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();

[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'

function ShowConsole
{
    $consolePtr = [Console.Window]::GetConsoleWindow()
    [Console.Window]::ShowWindow($consolePtr, 5) #5 show
}

function HideConsole
{
    $consolePtr = [Console.Window]::GetConsoleWindow()
    [Console.Window]::ShowWindow($consolePtr, 0) #0 hide
}
# Einde Console afsluiten en openen.

# VisualStyles aan zetten ------------------------------------------------------------------
[System.Windows.Forms.Application]::EnableVisualStyles()


<# Declareren variabelen ---------------------------------------------------------------------
   Bij functie standaardinstellingen onder sectie "Functions" staan de variabelen die door gebruikers
   gewijzigd kunnen worden #>

<# Programma versie variabelen

Versie = versie van dit programma wordt weergegeven in de titel

Extra label =  Een extra label wordt weergegeven bij info over dit programma. 
   Een extra label kan een pre-release zijn of een build.
   Een pre-release wordt aangegeven met alpha.DATE (of beta.DATE) en een build met BUILDNUMBER.DATE 
   De BUILDNUMBER geeft aan hoe vaak het programma uitgebracht is.

Modes:
    alpha      : Logbestanden verwijderen is uit, Automatisch updates is uit en Lokale mappen worden gebruikt
    beta       : Logbestanden verwijderen is uit, Automatisch updates is uit
    prerelease : Wordt gebruikt om alles te testen, dus ook updates en verwijderen logbestanden
    online     : Normale gebruik

    De modus hoeven niet pers allemaal doorlopen te worden!
    Bij het opstarten krijg je een melding als je in de testfase zit (modes alpha, beta en prelease).
#>
$global:programma = @{
    versie = "4.5.0"
    extralabel = "158.240110"
    mode = "online"
}

# startmap van het programma
$startmap=Split-Path -Parent $PSCommandPath

# map met png icoontjes
$icoontjesmap = -join ("$startmap","\","png")

# map voor logbestanden
$logmap = -join ("$startmap","\","log")

<# object met alle variabelen die in initialisatiebestand bewaard worden. Dit zijn de instellingen die gewijzigd kunnen worden.
   Zie ook functie gebruikersinstellingen onder sectie "Functions" #>
$Global:init=@{}

# locaties definiren zit nu onder beheer.ini en wordt bij de start gedefinieerd

<# beheerinstellingen die gedownload worden van Sharepoint en niet gewijzigd kunnen worden
   Zie ook script initialisatiebestandmaken.ps1 #>
$global:beheer=@{}


<# bestand met variabelen die gewijzigd kunnen worden en of extern bewaard moeten worden
   de variabele $global:initbestand wordt alleen gebruikt om in het begin de oude initialisatiebestand om te zetten naar de nieuw bestandsnaam
   de nieuw bestandsnaam wordt bepaald bij function bepaalinitnaamgebruiker. Zie onder kleinere functions
#>
$global:initbestand = "initialisatie.ini"
# volledige pad toevoegen aan variabele
$global:initbestand = -join ("$startmap","\","$global:initbestand")

# bestand met variabelen die niet gewijzigd kunnen worden 
$global:beheerbestand = "beheer.ini"
# volledige pad toevoegen aan variabele
$global:beheerbestand = -join ("$startmap","\","$global:beheerbestand")

# website met updates van programma
$updatewebsite = "https://beherenbestanden.neveshuis.nl"

# bestand met info over update. staat op de website
$global:updateinfo = "updateinfo.ini"

# de 2 bestanden met info voor venster informatieprogramma
$readmebestand="readme.txt"
$changelogbestand="changelog.txt"

# nodig voor werken met hashtabels. zie functies uitvoerentaken en overzichttaken
$uitvoeren = [hashtable]::Synchronized(@{})

# nodig voor informatie baloon 
$global:tooltip1 = New-Object System.Windows.Forms.ToolTip

# URL voor en mappen in Sharepoint
$global:Sharepoint = @{
    Url = "https://o365zadkine.sharepoint.com/teams/RPCPAL_55"
    bijlagen = "/gedeelde documenten/Studenten/Bijlagen Kandidaat"
    home = "/gedeelde documenten/studenten/Homemappen"
    backup = "/gedeelde documenten/studenten/Back-up"
    beheermap = "/teams/RPCPAL_55/Gedeelde documenten/RPC Projecten/Beherenbestanden/beheerinstellingen"
    beheerini = "beheer.ini"
    ingelogd = $false
    gebr_naam = ""
    gebr_inlog = "" 
    gebr_email = ""
}

# lokale mappen wordne gebruikt als programma.mode is alpha. zie start programma.
$lokalemappen = @{
    digitalebestanden = "C:\Users\$env:username\testwerking\digitale bijlagen"
    homemapstudenten  = "C:\Users\$env:username\testwerking\doel"
    backupmap         = "C:\Users\$env:username\testwerking\backup kandidaten"
}

# Einde declareren variabelen


# functions ---------------------------------------------------------------------------------
# hieronder de kleine functies die door andere functies gebruikt worden ---------------------

Function declareren_standaardvenster ($titel, $pos_x, $pos_y)
{
$StandaardForm                            = New-Object system.Windows.Forms.Form
# $StandaardForm.ClientSize                 = New-Object System.Drawing.Point($pos_x,$pos_y)
$StandaardForm.MaximumSize = New-Object System.Drawing.size($pos_x,$pos_y)
$StandaardForm.MinimumSize = New-Object System.Drawing.size($pos_x,$pos_y)
$StandaardForm.text                       = $titel
$StandaardForm.TopMost                    = $false
$StandaardForm.StartPosition              = 'CenterScreen'
$StandaardForm.BackColor = "white"
$StandaardForm.MaximizeBox = $False
$StandaardForm.Icon                       = [System.Drawing.Icon]::ExtractAssociatedIcon('beheren.ico')

return $StandaardForm
}


function bepaallognaam ($invoer)

{
<# de lognaam wordt bepaald adhv de invoer. dit is een datum in de format yyyy-mm-dd. Zie ook function Bepaaldatum.
   functie "bepaaldatumuitlognaam" doet het omgekeerde, dus een verandering hier moet ook in deze functie worden aangepast.
#>
# $lognaam = -join ("$logmap","\log_","$invoer",".txt")

# haal de personeelnr uit de beheervariabele
$personeelsnr = bepaalpersoneelsnr

$jaar = $invoer.substring(6, 4)
$maand = $invoer.substring(3, 2)
$dag = $invoer.substring(0, 2)
$datumintekst = -join ($jaar,'-',$maand,'-',$dag)
$lognaam = -join ("$logmap","\log_","$datumintekst",'_',$personeelsnr,".txt")

return $lognaam
}

Function bepaaleigenlogbestanden
{
$personeelsnr = bepaalpersoneelsnr

$uitvoer = "$logmap\*$personeelsnr.txt"

return $uitvoer
}


Function Logbestandtoevoegen ($logbestand) 
{
# tijdelijke log toevoegen aan eigen logbestand als deze al bestaat. bestand hernoemen wordt altijd gedaan.

# datum bepalen
$datumvandaag = bepaaldatum;

$logvanvandaag = bepaallognaam $datumvandaag
if (test-path -path $logvanvandaag -pathtype leaf) { 
    $inhoudlog = Get-Content -path $logvanvandaag
    Add-Content -Path $logbestand -Value $inhoudlog
    Remove-Item $logvanvandaag
}
# dit wordt altijd gedaan.....    
Rename-Item -Path $logbestand -NewName $logvanvandaag

}

function bepaalversiemap ($invoer)
{
# bepaalt de map waar de versie in staat mbv de gegeven versie (invoer)

$major = $invoer.split('.')[0]
$minor = $invoer.split('.')[1]
$revision = $invoer.split('.')[2]

$versiemap = -join ("$updatewebsite","/updates/","$major",".","$minor" )
return $versiemap
}

function bepaaldatum {
# datum bepalen
$datumvandaag = get-date -Format "dd-MM-yyyy"
return $datumvandaag
}

function bepaaltijd {

# huidige tijd bepalen
$huidigetijd = get-date -Format "HH:mm:ss"
return $huidigetijd
}

function bepaalpersoneelsnr
{

# bepalen van de bepaalpersoneelsnummer uit de variabele $global:sharepoint.gebr_inlog
$invoer = $global:sharepoint.gebr_inlog

# bepaal eerst de positie van de "@"
$positie = $invoer.indexof("@")

if ($positie -lt 1) {
    # als "@" niet gevonden wordt of op positie 0, dan de gehele string teruggeven
    $uitvoer = $invoer
    } else {
    $uitvoer = $invoer.substring(0,$positie)
    }

# test
# $uitvoer = "0101988"
return $uitvoer
}

function bepaalinitnaamgebruiker
{

# bepalen van de initialisatienaam van een bestand met gebruikersinstellingen

# invoer is altijd de gebruikers inlognaam van variabele $global:beheer
# mocht dit veranderen dan hoeft alleen de volgende regel verwijderd te worden en
# ($invoer) te worden toegevoegd aan het begin van de function.
$invoer = bepaalpersoneelsnr
 
# bestandsnaam wordt bv. gebruiker0101234.ini
$uitvoer = -join ("$startmap","\gebruiker",$invoer,".ini")

return $uitvoer
}

function gebruikersinstellingen 
{
# hier worden de standaardinstellingen gedeclareerd die gebruikers kunnen wijzigen

$algemeen=@{
    locatiekeuze = 'PAL'
    wissennabackup = 'Ja'
    maplegenvoorverplaatsen = 'Ja'
}
$opschonen=@{
    dagenbewarenlogs = 365
    opschonenlogs = 'Ja'
}
$Std_inst=@{
    algemeen  = $algemeen
    opschonen = $opschonen
}

return $Std_inst
}

function Get-IniContent ($filePath)
{
# Leest een bestand met instellingen en geeft deze terug als een array
    $ini = @{}
    switch -regex -file $FilePath
    {
        ^\[(.+)\] # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        ^(;.*)$ # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = Comment + $CommentCount
            $ini[$section][$name] = $value
        }
        (.+?)\s*=(.*) # Key
        {
            $name,$value = $matches[1..2]
            if ( $ini.count -gt 0 ) { $ini[$section][$name] = $value }
        }
    }
    return $ini
}


function declareren_rpcnrs {

# Venster voor weergeven rpcnummer declareren. Wordt bij meerdere functies gebruikt.

$listbox_temp = New-Object System.Windows.Forms.Listbox
$listbox_temp.Location = New-Object System.Drawing.Point(10,40)
$listbox_temp.Size = New-Object System.Drawing.Size(150,20)
$listbox_temp.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listbox_temp.SelectionMode = 'MultiExtended'
$listbox_temp.Height = 500

return $listbox_temp
}

function lijstrpcnrsaanmaken ($keuzelocatie, $listbox_temp) {
# een lijst met rpc-nummers wordt gemaakt adhv gekozen locatie

# lijst wordt leeggemaakt
$listbox_temp.Items.Clear()

# waarden uit array halen die nodig zijn om lijst te maken met rpc-nummers
[int]$keuzeeerstenr=$Global:beheer.locaties.$keuzelocatie.eerstenr
[int]$keuzelaatstenr=$Global:beheer.locaties.$keuzelocatie.laatstenr

#listbox items aanmaken
For ($i=$keuzeeerstenr; $i -le $keuzelaatstenr; $i++) {

    if ($i -lt 10) {$rpcnr="RPC-00"+"$i"}
    elseif ($i -lt 100) {$rpcnr="RPC-0"+"$i"}
    else {$rpcnr="RPC-"+"$i"}
    [void] $listbox_temp.Items.Add($rpcnr)
}

return $listbox_temp
}

function vraagvenster ($titel, $vraag, $knopok, $knopannuleren)  {

# venster declareren
$formvraag = declareren_standaardvenster $titel 600 200

$vraaglabel                     = New-Object system.Windows.Forms.Label
$vraaglabel.text                = $vraag
$vraaglabel.AutoSize            = $false
$vraaglabel.width               = 550
$vraaglabel.height              = 100
$vraaglabel.location            = New-Object System.Drawing.Point(20,10)
$vraaglabel.Font                = 'Microsoft Sans Serif,11'
$vraaglabel.ForeColor = [System.Drawing.Color]::Blue
$formvraag.Controls.Add($vraaglabel)

# knop ok wordt altijd weergegeven. knop annuleren alleen als een 2e knop-naam gegeven is.
$vraagok = New-object System.Windows.Forms.Button 
if (!($knopok -eq $null) ) { 
    $vraagok.text= $knopok
} else {
    $vraagok.text= "Ok"
}
# $vraagok.location = "50,130" 
$vraagok.location = New-Object System.Drawing.Point(50,120)
$vraagok.size = "150,30"  
if ($vraagok.text -eq "Ok") { $vraagok.BackColor = 'blue' }
   else { $vraagok.BackColor = 'green' }
$vraagok.ForeColor = 'white'
$vraagok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$formvraag.Controls.Add($vraagok)


if (!($knopannuleren -eq $null) ) { 
$vraagescape = New-object System.Windows.Forms.Button 
$vraagescape.text= $knopannuleren
$vraagescape.location = "250,120" 
$vraagescape.size = "150,30"  
$vraagescape.BackColor = 'red'
$vraagescape.ForeColor = 'white'
$vraagescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$formvraag.Controls.Add($vraagescape)
}

#$formvraag.controls.AddRange(@($vraaglabel, $vraagok, $vraagescape ))

$result = $formvraag.ShowDialog()
    
$formvraag.close();

return $result
}

Function declareren_uitlegvenster ($titel, $size_x, $size_y, $icoon_x, $icoon_y, $tekst) {
<# 
Hiermee kan je mbv een vraagteken in een venster extra uitleg geven.
variabele titel wordt als titel weergegeven.
variabele size_x en size_y geven de grootte vh venster op.
variabele icoon_x en icoon_y de positie van de vraagteken.
variabele tekst is de weer te geven informatietekst.
#>

# benodigde venster declareren
$Global:Form_uitleg_taak                    = New-Object system.Windows.Forms.Form
$Global:Form_uitleg_taak.StartPosition      = 'CenterScreen'
$Global:Form_uitleg_taak.BackColor          = "white"
$Global:Form_uitleg_taak.TopMost            = $true
$Global:Form_uitleg_taak.MaximumSize        = New-Object System.Drawing.size($size_x,$size_y)
$Global:Form_uitleg_taak.MinimumSize        = New-Object System.Drawing.size($size_x,$size_y)
$Global:Form_uitleg_taak.text               = $titel
$Global:Form_uitleg_taak.ControlBox         = $False
$Global:Form_uitleg_taak.Icon               = [System.Drawing.Icon]::ExtractAssociatedIcon('beheren.ico')

[int]$tekst_x = $size_x -10
[int]$tekst_y = $size_y -85

$Global:uitlegtaaktekst                     = New-Object system.Windows.Forms.Label
$Global:uitlegtaaktekst.AutoSize            = $false
$Global:uitlegtaaktekst.location            = New-Object System.Drawing.Point(10,10)
$Global:uitlegtaaktekst.Font                = 'Microsoft Sans Serif,11'
$Global:uitlegtaaktekst.ForeColor = [System.Drawing.Color]::blue
$Global:uitlegtaaktekst.text                = $tekst
$Global:uitlegtaaktekst.width               = $tekst_x
$Global:uitlegtaaktekst.height              = $tekst_y

$Global:Form_uitleg_taak.Controls.Add($Global:uitlegtaaktekst)

[int]$knop_x = 250
[int]$knop_y = $size_y -75

$knopsluiten = New-object System.Windows.Forms.Button 
$knopsluiten.text= 'Sluiten'
$knopsluiten.location = New-Object System.Drawing.size($knop_x,$knop_y)
$knopsluiten.size = "150,30"  
$knopsluiten.BackColor = 'red'
$knopsluiten.ForeColor = 'white'
$knopsluiten.DialogResult = [System.Windows.Forms.DialogResult]::ok

$Global:Form_uitleg_taak.Controls.Add($knopsluiten)

# vraagteken weergeven om extra info te geven.
$Global:vraagtekenicoon                     = new-object Windows.Forms.PictureBox
$Global:vraagtekenicoon.Location            = New-Object System.Drawing.Size($icoon_x, $icoon_y)
$Global:vraagtekenicoon.Size                = New-Object System.Drawing.Size(30,60)
$Global:vraagtekenicoon.Image               = [System.Drawing.Image]::FromFile("$icoontjesmap\icoon-hulp.png")
$Global:vraagtekenicoon.add_click( { $Global:Form_uitleg_taak.showdialog() } )
$Global:vraagtekenicoon.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Klik hier voor uitleg over de taak." )
})
# $Global:vraagtekenicoon.add_MouseLeave( { $Global:Form_uitleg_taak.hide() } )

} # einde declareren_uitlegvenster

function VerbindSharepoint {

$ingelogd = $false

# begin van while-loop om inloggegevens te controleren
do {
try {
    Connect-PnPOnline -Url $global:Sharepoint.Url -Interactive -ValidateConnection -ErrorAction Stop 
       

    $ctx = Get-PnPContext -ErrorAction Stop
    $ctx.Load($ctx.Web.CurrentUser)
    $ctx.ExecuteQuery() 

    # inloggegevens verzamelen
    $global:Sharepoint.gebr_email = $ctx.Web.CurrentUser.Email
    $global:Sharepoint.gebr_inlog = $ctx.Web.CurrentUser.UserPrincipalName
    $global:Sharepoint.gebr_naam = $ctx.Web.CurrentUser.Title
    
    $ingelogd = $true
    } # einde try

# verbinding verbroken met Sharepoint.
catch [System.Management.Automation.MethodInvocationException] {
    $melding = "Te lang gewacht op verbinding met Sharepoint."
}

# verbinding verbroken met Sharepoint.
catch [System.Management.Automation.RuntimeException] {
    $melding = "Verbinding met Sharepoint is verbroken. "
}

# de gebruiker heeft geen rechten op de Sharepoint.
catch [System.Net.Http.HttpRequestException] {
    $melding =  "Er is een probleem met de netwerkverbinding. "
}

# de aanmelding is geannuleerd door op het kruisje te klikken
catch [Microsoft.Identity.Client.MsalClientException] {
    $melding =  "De aanmelding is geannuleerd. "
}

# de aanmelding is geannuleerd door op knop Vorige te klikken
catch [Microsoft.Identity.Client.MsalServiceException] {
    $melding = "De aanmelding is niet gelukt."
}

# de gebruiker heeft geen rechten op de Sharepoint.
catch [System.Net.WebException] {
    $melding =  "De gekozen gebruiker heeft geen toegangsrechten op Sharepoint 
of de verbinding is vervallen."
}



# Het volgende wordt gebruikt om alle andere foutmeldingen op te vangen.
catch {
    # test om de foutcode te achterhalen. dit gebruiken als je een nieuwe type fout wilt ondervangen
    # $error[0].Exception.GetType().fullname >> errors.txt

    $melding =  "De volgende foutmelding is geretourneerd:" +  "`r`n" + "- $_"
      } # einde catch

if (!($ingelogd)) {
    $doorgaan = vraagvenster "Er is geen verbinding met SharePoint" "$melding

Dit programma heeft een verbinding met het RPC SharePoint-site nodig.
Wilt u opnieuw aanmelden of afsluiten?. 
" "Aanmelden" "Afsluiten"

} else {
   $doorgaan = "N"
}

} 
while ( $doorgaan -eq "Ok" ) # einde while-loop inloggegevens controleren

#  $ingelogd in sharepoint variabele plaatsen
$global:Sharepoint.ingelogd = $ingelogd

} # einde function VerbindSharepoint

Function Inlezengebruikersinstellingen {

# Bepalen van de persoonlijke initialisatiebestand.
$gebruikersbestand = bepaalinitnaamgebruiker

# standaard instellingen bepalen voor object $init
$global:init = gebruikersinstellingen

# inlezen initialisatiebestand als deze bestaat en toevoegen of verwijderen waarden van $init
# dit is nodig zodat, als de initialisatiebestand wordt ingelezen, eventuele nieuwe variabelen worden behouden en verwijderde variabelen niet worden toegevoegd. 
if (test-path -path $gebruikersbestand -pathtype leaf) { 
    # inlezen van object als hashwaarden. hier staan de gewijzigde waarden in die je wil behouden.
    $myObject = Get-Content -Path $gebruikersbestand | ConvertFrom-Json

    # waarden overzetten naar $init. nieuwe waarden worden behouden. verwijderde waarden worden niet toegevoegd.
    foreach( $property in $myobject.psobject.properties.name ) {
        foreach( $subproperty in $myobject.$property.psobject.properties.name )
        {
        # alleen toevoegen als deze bij 'init' al bestaat
        if ( $global:init.$property.$subproperty -ne $null) { 
            $global:init[$property][$subproperty] = $myObject.$property.$subproperty 
            }
        } # einde foreach $subproperty - loop 
        } # einde foreach $property - loop    

    # gekozen is om dit altijd te bewaren zodat je lijst met variabelen up to date is.
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $gebruikersbestand
    } 

}

# hieronder de hoofdfuncties ----------------------------------------------------------------



function scriptRun {


# nodig voor afhandelen foutmeldingen
$uitvoeren.foutmelding = $false

# nodig om in logbestand te schrijven
$logbestand = $uitvoeren.logbestand

# hier wordt de taak uitgevoerd.
switch ($uitvoeren.taak) {

    "backup"   { 

    # datum en tijdstip van vandaag in variabele plaatsen. nodig om de backup-mapnaam te bepalen.
    $datumvandaag = get-date -Format "yyyy-MM-dd__HH-mm-ss"

    #kopiren bestanden naar studentmappen
    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()
        
        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "

        # bepalen bronmap. dit is de homemap van de kandidaten
        $bronmap = -join ($uitvoeren.homemap,'\',$rpcitem)

        # bepalen doelmap. dit is de map waar de backup in komt.
        $doelmap = -join ($uitvoeren.doelmap,'\',$datumvandaag,'\',$rpcitem)

        # errors leeg maken
        $error.clear()
            try {
                #backup maken
                # de toevoeging \\? voor de bronmap en doelmap zorgt ervoor dat lange namen - meer dan maximaal 256 tekens, geen foutmelding geven en dus het kopieren en verwijderen ook dan lukt.
                Copy-Item -path "\\?\$bronmap" -destination "\\?\$doelmap" -recurse -Force -container -ErrorAction Stop

                # en daarna wissen als dit geselecteerd is
                if ($uitvoeren.wissennabackup -eq $true) { 
                    # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                    Remove-Item "\\?\$bronmap\mijn documenten\*" -Recurse -Force -ErrorAction Stop
                    # dan de root van rpc-map exclusief map mijn documenten
                    Remove-Item "\\?\$bronmap\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                    }
                } # einde try

            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch

    } # einde foreach rpcitem

               } # einde taak backup

    "kopiren" { 

    # array aanmaken en vullen met geselecteerde items. 
    # Deze items worden vervolgens gekopierd.
    $geselecteerdeitems = [System.Collections.ArrayList]@()

    <# Als er geen items zijn geselecteerd in de examenmap dan moet de gehele map worden gekopierd.
   hiervoor wordt dan de pad naar de examenmap toegevoegd aan de array $geselecteerdeitems.
   anders worden de geselecteerde items toegevoegd aan de array.
    #>
    if ($uitvoeren.listview1.selecteditems.count -eq 0) {
        $bronmap = -join ($uitvoeren.bronmap,'\*')
        $geselecteerdeitems.Add("$bronmap")
        } else {
        foreach ($item in $uitvoeren.listview1.selecteditems) {
            $bronmap = -join ($uitvoeren.bronmap,'\',$item[0].text)
            $geselecteerdeitems.Add("$bronmap")
        }
    }

    #kopiren bestanden naar studentmappen

    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "

        # doelmap bepalen. dit is een lokale variabele
        $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
    
        # kopieren geselecteerde mappen of bestanden
            
        foreach ($item in $geselecteerdeitems) {
        $error.clear()
        try {
             Copy-Item -path "$item" -destination "$doelmap" -recurse -Force -ErrorAction Stop
             
            }

        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
            $uitvoeren.foutmelding = $true
              } # einde catch
            } # einde foreach $item
        
    } # einde foreach $rpcitem

    # array legen. mss is dit niet nodig!
    $geselecteerdeitems.Clear()
    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    $uitvoeren.listbox.selecteditems.clear()

               } # einde taak kopiren

    "wissen"   { 
        #wissen van bestanden in studentmappen
        foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
            # progressie laten zien op balk
            $uitvoeren.progressbar.PerformStep()

            # teksten met meldingen voor het logbestand
            $foutmelding_log = "[ $rpcitem - FOUT ] : "
            
            # doelmap bepalen. dit is een lokale variabele voor de deel-functie wissen hieronder.
            $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
            $doelmaproot = -join ($uitvoeren.homemap,'\',$rpcitem)

            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "\\?\$doelmap\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "\\?\$doelmaproot\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
            
            } # einde foreach statement

               } # einde taak wissen

    "verplaatsen" {
        # er is maar een actie te doen dus...
        $uitvoeren.progressbar.maximum = 1

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ FOUT ] : "

        # definiren bron- en doelmap
        $bronmap = $uitvoeren.bronmap
        $doelmap = $uitvoeren.doelmap

        # doelmap wordt geleegd voor het verplaatsen of kopiren, als dit gekozen is.
        if ($uitvoeren.doelmaplegen -eq $true) {
            $error.clear()
            try {
                # verwijderen van bestanden in doelmap
                Remove-Item "\\?\$doelmap\*" -Recurse -Force -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        }

        # kopieren of verplaatsen
        $error.clear()
        try {
            # eerst kopiren
            Copy-Item -path "\\?\$bronmap" -destination "\\?\$doelmap" -recurse -ErrorAction Stop

            # verwijderen van bestanden als keuze is verplaatsen. alleen de inhoud van mijn documenten
            if ($uitvoeren.keuzeverplaatsen -eq "verplaatsen") {
                Remove-Item "\\?\$bronmap" -Recurse -Force -ErrorAction Stop
                }
            }
        catch {
              
              $uitvoeren.foutmelding = $true
              # foutmelding van PowerShell naar logbestand
              "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
              
              } # einde catch

        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

                  } # einde taak verplaatsen

    "opschonen"   { 
        #wissen van bestanden in studentmappen
        foreach ($rpcitem in $uitvoeren.listbox.items) {
            # progressie laten zien op balk
            $uitvoeren.progressbar.PerformStep()

            # teksten met meldingen voor het logbestand
            $foutmelding_log = "[ $rpcitem - FOUT ] : "
            
            # doelmap bepalen. dit is een lokale variabele voor de deel-functie wissen hieronder.
            $doelmap = -join ($uitvoeren.doelmap,'\',$rpcitem)

            $error.clear()
            try {
                # compleet verwijderen van mappen. 
                Remove-Item "\\?\$doelmap" -Recurse -Force -ErrorAction Stop

                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
            
            } # einde foreach statement

               } # einde taak wissen

} # einde switch commando $uitvoeren.taak

} # einde scriptRun

function uitvoerentaken {
# hier worden de 4 belangrijkste taken uitgevoerd.

# Beheerinstellingen worden in een verkorte variabelenaam gezet tbv de leesbaarheid. 
# dit is handig maar ook iig nodig bij weergeven van de map in vraagvenster hieronder.
$digitalebestanden = $global:beheer.examenmappen.digitalebestanden
$backupmap = $global:beheer.examenmappen.backupmap

# controleren of mappen bestaan - afhankelijk van de taak
# map uitvoeren.homemap wordt in ieder geval gecontroleerd

if (!(test-path -path $uitvoeren.homemap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De homemappen van de studenten zijn niet gevonden!
Controleer of de volgende map aanwezig is :
- $uitvoeren.homemap

De taak kan nu niet uitgevoerd worden." "OK"
    return;
} # einde test voor map uitvoeren.homemap

if ($uitvoeren.taak -eq "kopiren") {
if (!(test-path -path $digitalebestanden -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
Controleer of de volgende map aanwezig is :
- $digitalebestanden

De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map digitalebestanden

if ($uitvoeren.taak -eq "backup") {
if (!(test-path -path $backupmap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De backupmap is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map backupmap

# einde controleren of mappen bestaan

# Extra beveiliging voordat je de taak opschonen gaat uitvoeren

if ($uitvoeren.taak -eq "opschonen") {
  $vraagopschonen="LET OP : Als u nu op Opschonen klikt worden de bestanden definitief verwijderd!

Dit kan niet worden teruggedraaid.

Klik op Annuleren als u terug wilt.
"
   $result=vraagvenster "Starten met opschonen?" $vraagopschonen "Opschonen" "Annuleren"

   if ( $result -eq "Cancel") { return }
}

# startknop wordt onzichtbaar en venster met functie gesloten
$StartButton.Hide()
$Btnescape.Hide()
$form2.hide();


# het proces zichtbaar maken in een balk
$uitvoeren.progressbar = New-Object System.Windows.Forms.ProgressBar
$uitvoeren.progressbar.Location = New-Object System.Drawing.Point(20, 40)
$uitvoeren.progressbar.Size = New-Object System.Drawing.Size(560, 30)
$uitvoeren.progressbar.Style = "continuous"

# de maximumwaarde van de progressbar. Deze is bij taak opschonen anders.
if ($uitvoeren.taak -eq "opschonen") {
    $uitvoeren.progressbar.maximum = $listbox.items.count
    } else {
    $uitvoeren.progressbar.maximum = $listbox.selecteditems.count
    }
$uitvoeren.progressbar.step = 1

# ProgressBar toevoegen aan form3
$uitvoeren.form3.Controls.Add($uitvoeren.progressbar);

# teksten en progressbar veranderen
$Label.hide()
$Description3.hide()
$Description2.ForeColor = 'green'
$Description2.Text = "De taak wordt uitgevoerd ..."
$uitvoeren.progressbar.visible

# tijdelijk logbestand bepalen
$tijdelijkelog = "tijdelijkelog.txt"

# logbestandsnaam definiren en volledige pad naar bestand invoeren
$logbestand = -join ("$logmap","\",$tijdelijkelog)

# doorgeven aan hastable uitvoeren
$uitvoeren.logbestand = $logbestand

# starttijd van loggen naar variabele
$logtijd = bepaaltijd

# map aanmaken voor logbestanden als deze niet bestaat
if (!(Test-Path "$logmap")) { mkdir "$logmap" } 

# in logbestand info over de taak schrijven en beginnen met uitvoeren van taak ---------------------------

"De taak " + $uitvoeren.taak + " is gestart." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append
$objtekst1.Text | out-file $logbestand -Append
if ($uitvoeren.taak -eq "kopiren") {
    $objtekst2.Text | out-file $logbestand -Append
    } elseif ($uitvoeren.taak -eq "backup") {
    if ($wissennabackup.checked -eq $true) { "De bestanden worden na de backup gewist." | out-file $logbestand -Append }
    } elseif ($uitvoeren.taak -eq "verplaatsen") {
    if ($keuzeoptie1.Selectedindex -eq "1") { 
        "U gaat bestanden kopiren van een rpc-nummer naar een andere." | out-file $logbestand -Append
        } else {
        "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." | out-file $logbestand -Append
        }
     if ($doelmaplegen.checked -eq $true) { 
        "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd." | out-file $logbestand -Append
                    } else {
        "De bestanden worden toegevoegd aan de bestanden in de doelmap." | out-file $logbestand -Append
                    }
    }


# ------ begin runspaces ----------------------------------------------

#Configure max thread count for RunspacePool.
$maxthreads = [int]$env:NUMBER_OF_PROCESSORS
    
#Create a new session state for parsing variables ie hashtable into our runspace.
$hashVars = New-object System.Management.Automation.Runspaces.SessionStateVariableEntry -ArgumentList 'uitvoeren',$uitvoeren,$Null
$InitialSessionState = [System.Management.Automation.Runspaces.InitialSessionState]::CreateDefault()
    
#Add the variable to the RunspacePool sessionstate
$InitialSessionState.Variables.Add($hashVars)

#Create our runspace pool. We are entering three parameters here min thread count, max thread count and host machine of where these runspaces should be made.
$script:runspace = [runspacefactory]::CreateRunspacePool(1,$maxthreads,$InitialSessionState, $Host)

#Create a PowerShell instance.
$script:powershell = [powershell]::Create()
    
#Open a RunspacePool instance.
$script:runspace.Open()
         
#Add our main code to be run via $scriptRun within our RunspacePool.
$script:powershell.AddScript(${Function:scriptRun})
$script:powershell.RunspacePool = $script:runspace
        
#Run our RunspacePool.
$script:handle = $script:powershell.BeginInvoke()

#Wait for code to complete and keep UI responsive
do {
		[System.Windows.Forms.Application]::DoEvents()
		Start-Sleep -Milliseconds 1 
} while (!$script:handle.IsCompleted)

#Cleanup our RunspacePool threads when they are complete ie. GC.
if ($script:handle.IsCompleted)
        {
            $script:powershell.EndInvoke($script:handle)
            $script:powershell.Dispose()
            $script:runspace.Dispose()
            $script:runspace.Close()
            [System.GC]::Collect()
        }

# ----- Einde runspaces -----------------------------------------------

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = bepaaltijd


"" | out-file $logbestand -Append
"Eindtijd  : $logtijd" | out-file $logbestand -Append
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"" | out-file $logbestand -Append

# tijdelijke log toevoegen aan eigen logbestand als deze al bestaat. 
Logbestandtoevoegen $logbestand


# aangeven dat taken zijn uitgevoerd 
if ($uitvoeren.foutmelding) { 
    $Description2.ForeColor = 'red'
    $Description2.Text = "De taak is niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $Description2.Text = "De taak is uitgevoerd." }

# knoppen zichtbaar maken
$EndButton.show()
$LogButton.show()

# alleen bij taak kopieren onderstaande knop zichtbaar maken
if ($uitvoeren.taak -eq "kopiren") {
    $Btnescape.size = New-Object System.Drawing.Size(200,40)
    # escape knop wordt nu opnieuw knop
    $Btnescape.text= "Opnieuw bestanden klaarzettenn"
    $Btnescape.BackColor = 'green'
    $Btnescape.show()
    $form2.show()
} else {
# knop logbestand bekijken wordt nu naar links verplaatst om aan te sluiten met knop sluiten.
$LogButton.Location = New-Object System.Drawing.Size(160, 400)
}

} # einde uitvoerentaken

function overzichttaken ([string]$taak) {
# na het bevestigen van je keuze bij een van de 4 taken kom je bij deze functie.
# hier zie je een overzicht en kan je de taak starten of nog terug.

# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$digitalebestanden = $global:beheer.examenmappen.digitalebestanden
$homemapstudenten = $global:beheer.examenmappen.homemapstudenten
$backupmap = $global:beheer.examenmappen.backupmap

# hashtable object leeg maken voor het geval het nog waarden heeft.
$uitvoeren.clear()

# definiren venster
switch ($taak) {
    "backup"      { $titel = "Overzicht uit te voeren taak Backup maken " }
    "kopiren"    { $titel = "Overzicht uit te voeren taak Bestanden klaarzetten" }
    "wissen"      { $titel = "Overzicht uit te voeren taak Wissen" }
    "verplaatsen" { $titel = "Overzicht uit te voeren taak Verplaatsen of kopiren" }
    "opschonen"   { $titel = "Overzicht uit te voeren taak Opschonen" }
}

$uitvoeren.Form3 = declareren_standaardvenster $titel 600 500

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.AutoSize            = $false
$Description2.width               = 570
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,10)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor           = 'blue'

# onderstaande tekst wordt alleen zichtbaar als backuptaak is gekozen en wissen na backup is geselecteerd.
$Description3                     = New-Object system.Windows.Forms.Label
$Description3.AutoSize            = $false
$Description3.width               = 500
$Description3.height              = 20
$Description3.location            = New-Object System.Drawing.Point(20,28)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.Text                = "De bestanden worden na de backup gewist."
$Description3.ForeColor           = 'blue'
$Description3.hide()

$StartButton = New-Object System.Windows.Forms.Button
$StartButton.Location = New-Object System.Drawing.Size(10, 400)
$StartButton.Size = New-Object System.Drawing.Size(120, 50)
$StartButton.Text = "Start"
$StartButton.height = 40
$StartButton.BackColor = 'green'
$StartButton.ForeColor = 'white'
$StartButton.Add_click( {
    # toevoegen object en variabelen aan hastable voor uitvoeren 
    $uitvoeren.taak=$taak
    $uitvoeren.homemap=$homemapstudenten
    $uitvoeren.listbox = New-Object System.Windows.Forms.Listbox
    $uitvoeren.listbox = $listbox

    <# specifieke variabelen voor de gegeven taak.
       o.a. toevoegen tekst aan variabele uitvoeren.logbestandtekst om in logbestand te plaatsen
    #>
    switch ($taak) {

        "kopiren" {
        $uitvoeren.ListView1 = New-Object System.Windows.Forms.ListView
        $uitvoeren.ListView1 = $global:ListView1
        
        $uitvoeren.bronmap = $digitalebestanden
        foreach ($item in $global:geselecteerdebronmap) {
                    $uitvoeren.bronmap  = -join ($uitvoeren.bronmap, '\', $item)
                }
        }

        "backup" {
        $uitvoeren.doelmap="$backupmap"
        $uitvoeren.wissennabackup=$wissennabackup.checked
        }

        "verplaatsen" {
        # bepalen doel-, bronmap en doelmaplegen
        $uitvoeren.bronmap = -join ($homemapstudenten,"\",$bronselectie.selecteditem,"\Mijn Documenten\*")
        $uitvoeren.doelmap = -join ($homemapstudenten,"\",$doelselectie.selecteditem,"\Mijn Documenten")
        $uitvoeren.doelmaplegen=$doelmaplegen.checked
        # keuze tussen kopieren of verplaatsen doorgeven
        if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $uitvoeren.keuzeverplaatsen = "kopiren" 
                    } else {
                    $uitvoeren.keuzeverplaatsen = "verplaatsen" 
                    }
        }

        "opschonen" {
        $uitvoeren.doelmap="$backupmap"
        
        }
    } # einde switch $taak

    # $form2.hide()

    uitvoerentaken;
    
    });

$EndButton = New-Object System.Windows.Forms.Button
$EndButton.Location = New-Object System.Drawing.Size(10, 400)
$EndButton.Size = New-Object System.Drawing.Size(120, 50)
$EndButton.Text = "Sluiten"
$EndButton.height = 40
$EndButton.BackColor = 'red'
$EndButton.ForeColor = 'white'
$EndButton.DialogResult = [System.Windows.Forms.DialogResult]::OK
$EndButton.hide()

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Terug"
$Btnescape.location = New-Object System.Drawing.Size(160, 400)
$Btnescape.size = New-Object System.Drawing.Size(120, 50)
$Btnescape.height = 40
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(400, 400)
$LogButton.Size = New-Object System.Drawing.Size(170, 50)
$LogButton.Text = "Logbestand bekijken"
$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.dispose()
    $uitvoeren.Form3.dispose()

    vensterlogbestand })

$Label = New-Object System.Windows.Forms.Label
$Label.Font = 'Microsoft Sans Serif,12'
$Label.ForeColor = 'blue'
$Label.Text = "Klaar om de geselecteerde taak uit te voeren ?"
$Label.Location = New-Object System.Drawing.Point(20, 50)
$Label.Width = 480
$Label.Height = 20

switch ($taak) {
    "backup"      { 
                  $Description2.text = "U gaat een backup uitvoeren op de volgende rpc-nummers." 
                  if ($wissennabackup.checked -eq $true) { 
                    $Description3.text = "De bestanden worden na de backup gewist."
                    $Description3.show() 
                    }
                  }
    "kopiren"    { $Description2.text = "U gaat bestanden of mappen klaarzetten op de volgende rpc-nummers." }
    "wissen"      { $Description2.text = "U gaat bestanden wissen van de volgende rpc-nummers." }
    "verplaatsen" { 
                  if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $Description2.text = "U gaat bestanden kopiren van een rpc-nummer naar een andere." 
                    } else {
                    $Description2.text = "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." 
                    }
                  $Description3.show() 
                  if ($doelmaplegen.checked -eq $true) { 
                    $Description3.text = "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd."
                    } else {
                    $Description3.text = "De bestanden worden toegevoegd aan de bestanden in de doelmap."
                    }
                  }
    "opschonen"   { $Description2.text = "U gaat backups van de studentmappen verwijderen." }
} # einde switch taak

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,80) 
$objtekst1.Size = New-Object System.Drawing.Size(200,290)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = "RPC-nummers:" + "`r`n" + "`r`n"
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'

$objtekst2 = New-Object System.Windows.Forms.textbox
$objtekst2.Location = New-Object System.Drawing.Size(230,80) 
$objtekst2.Size = New-Object System.Drawing.Size(350,290)
$objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst2.Text = ""
$objtekst2.ReadOnly = $true
$objtekst2.Multiline = $true
$objtekst2.ScrollBars = "Both"
$objtekst2.Visible = $false
$objtekst2.BackColor  = 'white'
$objtekst2.WordWrap = $false

# geselecteerde rpc-nummers links weergeven
# als taak is verplaatsen heb je een andere inhoud dan bij overige taken
if ($taak -eq "verplaatsen") {
    $objtekst1.Text = $objtekst1.Text + " Bron is " + $bronselectie.selecteditem + "`r`n" + "`r`n"
    $objtekst1.Text = $objtekst1.Text + " Doel is " + $doelselectie.selecteditem + "`r`n"

    } elseif ($taak -eq "opschonen") {
    $objtekst1.Text = "Er zijn " + $listbox.items.count + " mappen met backups ouder dan " + $objTextBox1.Text + " dagen: "+ "`r`n" + "`r`n"
    foreach ($item in $listbox.items) {
        $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
        }

    } else {
    foreach ($item in $listbox.selecteditems) {
        $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
        }
    }

# geselecteerde mappen bij taak kopiren rechts weergeven. alleen als taak kopieren is geslecteerd
if ($taak -eq "kopiren") {
    $objtekst2.Text = "Examenmap:" + "`r`n"
    $objtekst2.Visible = $true

    # bepalen van geselecteerde bronmap.
    [string] $selectie = ""
    foreach ($item in $global:geselecteerdebronmap) {
          $selectie = -join ($selectie, '\', $item)
          }
    $objtekst2.Text = $objtekst2.Text + " - " + "$selectie" + "`r`n" + "`r`n"

    # alleen als er subitems zijn geselecteerd in middelste venster, overzicht geven
    if ($listview1.selecteditems.count -gt 0) {
        
        # bepalen bronmap
        $selectie = -join ($digitalebestanden, '\', $selectie)
        # aangeven of de eerste item is gevonden. alleen bij de 1e wordt extra text weergegeven
        $eerste = $true
        # inlezen en bepalen of er mappen zijn
        foreach ($item in $ListView1.selecteditems) {
            # inlezen geselecteerde items
            $inleesitem = $item[0].text
            # bepalen van map die gecontroleerd wordt
            $controleitem = -join ($selectie, '\', $inleesitem)

            
            # alleen weergeven als dit een map is
            if (( test-path -path "$controleitem" -pathtype container) -eq $true)  {
                # alleen bij de eerste item
                if ($eerste) {
                    $objtekst2.Text = $objtekst2.Text + "Submappen :" + "`r`n"
                    $eerste = $false
                    }
                $objtekst2.Text = $objtekst2.Text + " - " + "$inleesitem" + "`r`n"
                }
            }# einde 1e for each item

        # lege regel plaatsen, alleen als er mappen zijn weergegeven
        if (!($eerste)) { $objtekst2.Text = $objtekst2.Text + "`r`n" }

        # aangeven of de eerste item is gevonden. alleen bij de 1e wordt extra text weergegeven
        $eerste = $true
        # inlezen en bepalen of er bestanden zijn
        foreach ($item in $ListView1.selecteditems) {
            # inlezen geselecteerde items
            $inleesitem = $item[0].text
            # bepalen van map die gecontroleerd wordt
            $controleitem = -join ($selectie, '\', $inleesitem)

            # alleen weergeven als dit een bestand is
            if (( test-path -path "$controleitem" -pathtype container) -eq $false)  {
                # alleen bij de eerste item
                if ($eerste) {
                    $objtekst2.Text = $objtekst2.Text + "Bestanden :" + "`r`n"
                    $eerste = $false
                    }
                $objtekst2.Text = $objtekst2.Text + " - " + "$inleesitem" + "`r`n"
                }
            } # einde 2e for each item

        } # einde ($listview1.selecteditems.count -gt 0)
    } # einde ($taak -eq "kopiren")

$uitvoeren.Form3.Controls.AddRange(@($Description2, $Description3, $StartButton, $EndButton, $Btnescape, $LogButton, $Label, $objtekst1, $objtekst2 ))

$result = $uitvoeren.form3.ShowDialog()

$uitvoeren.Form3.Close()

if ($result -eq [system.windows.forms.dialogResult]::OK) { 
    $Form2.Close()
    $form.show()
    }

} # einde overzichttaken

function startknopklikbaar {
# deze functie wordt alleen gebruikt bij functie Vensterkopieren
# en bepaald of knoppen en items van vensterkopieren zichtbaar moeten zijn

# start knop
if (($global:listbox.selecteditems.count -gt 0) -and ($global:geselecteerdebronmap.count -ge 2)) {
    $Btnstart.Enabled= $true
} else {
    $Btnstart.Enabled= $false
}

} # einde startknopklikbaar

function vensterkopieren { 

function toevoegen_lijst1 ($controlemap, $toevoegitem) {
    if (( test-path -path "$controlemap\$toevoegitem" -pathtype container) -eq $true)  {
        [void] $listView1.Items.Add($toevoegitem, 0)
        } else {
        [void] $listView1.Items.Add($toevoegitem, 1)
        }
}

# taak bestanden overzetten begint hier

# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$digitalebestanden = $global:beheer.examenmappen.digitalebestanden
$homemapstudenten = $global:beheer.examenmappen.homemapstudenten

# gekozen locatie in makkelijke variabele plaatsen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# lijst met geselecteerde examenmappen
$global:geselecteerdebronmap = [System.Collections.ArrayList]@()

if (!(test-path -path "$digitalebestanden")) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
Controleer of de volgende map aanwezig is :
- $digitalebestanden

De taak kan nu niet opgestart worden." "OK" 
    return;
}

if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}


# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# De hoofdmenu onzichtbaar maken
$form.Hide()

$Form2 = declareren_standaardvenster "Bestanden klaarzetten in de studentmappen" 920 650;

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "RPC-nummers"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 42
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.location            = New-Object System.Drawing.Point(550,40)
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Crebonummer"
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(550,80)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Kerntaak"
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(550,120)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description8                     = New-Object system.Windows.Forms.Label
$Description8.text                = "Examen"
$Description8.AutoSize            = $false
$Description8.width               = 400
$Description8.height              = 42
$Description8.Font                = 'Microsoft Sans Serif,11'
$Description8.location            = New-Object System.Drawing.Point(550,160)
$Description8.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,550" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "kopiren" }) 
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,550" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

$BtnOpnieuw                         = New-Object system.Windows.Forms.Button
$BtnOpnieuw.width                   = 40
$BtnOpnieuw.height                  = 40
$BtnOpnieuw.location                = New-Object System.Drawing.Point(150,200)
$BtnOpnieuw.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoontje-home.png")
$BtnOpnieuw.Add_Click({ 

      # array wordt leeggemaakt
      $geselecteerdebronmap.Clear()

      # selectie krijgt waarde van gekozen crebonummer
      $selectie = $digitalebestanden

      # inlezen gekozen map en in variabele plaatsen
      $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

      # toevoegen aan venster
      $listView1.items.clear()
      foreach($folder in $folders){
           toevoegen_lijst1 $selectie $folder 
      }
      $listview1.SelectedItems.Clear()
      $listView1.AutoResizeColumns(1)

      # venster met inhoud map legen
      $listView2.items.clear()
      $objtekst2.Text = $Startexamenmap
      
      # dropdownmenu's leegmaken
      $lijstkerntaken.items.clear()
      $lijstexamens.items.clear()
      # selecties leegmaken
      $lijstcrebonrs.selectedindex = -1
      $lijstkerntaken.selectedindex = -1
      $lijstexamens.selectedindex = -1
      startknopklikbaar;
})
$BtnOpnieuw.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Alle keuzes wissen en opnieuw beginnen." )
})

$BtnTerug                         = New-Object system.Windows.Forms.Button
$BtnTerug.width                   = 40
$BtnTerug.height                  = 40
$BtnTerug.location                = New-Object System.Drawing.Point(150,245)
$BtnTerug.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-terug.png")
$BtnTerug.Add_Click({ 
    # selectie krijgt waarde van startmap
    $selectie = $digitalebestanden
    
    switch ($geselecteerdebronmap.count) {
           "0" { # niets doen 
               }
           "1" { 
           #verwijder alles
           $geselecteerdebronmap.Clear()
           # dropdownmenu's leegmaken
           $lijstkerntaken.items.clear()
           $lijstexamens.items.clear()
           # selecties leegmaken
           $lijstcrebonrs.selectedindex = -1
           $lijstkerntaken.selectedindex = -1
           $lijstexamens.selectedindex = -1
               }
           "2" { 
           #verwijder de laatste
           $geselecteerdebronmap.RemoveAt(1)
           # dropdownmenu's leegmaken
           $lijstexamens.items.clear()
           # selecties leegmaken
           $lijstkerntaken.selectedindex = -1
           $lijstexamens.selectedindex = -1
               }
           "3" { 
           #verwijder de laatste
           $geselecteerdebronmap.RemoveAt(2)
           # selecties leegmaken
           $lijstexamens.selectedindex = -1
               }
           default { 
           $verwijdernr=$geselecteerdebronmap.Count-1
           $geselecteerdebronmap.RemoveAt($verwijdernr)
           }
    } # einde switch

    # Standaard map
    $objtekst2.Text = $Startexamenmap
    # toevoegen aan array en geselecteerde examenmap
    foreach ($item in $geselecteerdebronmap) {
            $selectie = -join ($selectie, '\', $item)
            # Toevoegen aan geselecteerde examenmap
           $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $Item)
    } # einde foreach

    # inlezen gekozen map en in variabele plaatsen
    $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

    # toevoegen aan venster 
    $listView1.items.clear()
    foreach($folder in $folders){
           toevoegen_lijst1 $selectie $folder 
           
    }
    $listview1.SelectedItems.Clear()
    $listView1.AutoResizeColumns(1)

    # venster met inhoud map legen
    $listView2.items.clear()

    startknopklikbaar;
 }) # einde BtnTerug.add_click

$BtnTerug.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "De laatste keuze wissen en n stap terug." )
})

# listbox is al in het begin gedeclareerd. onderstaande waarden gelden voor deze functie.
$listBox.Location = New-Object System.Drawing.Point(10,40)
$listBox.Size = New-Object System.Drawing.Size(130,500)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.BackColor  = 'white'
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waar de bestanden naar toe worden overgezet." )
})


# bij aanklikken van een rpcnr, kijken of startknop weergegeven kan worden
$listbox.add_SelectedIndexChanged(
     { startknopklikbaar;
     } )

$imageList = new-Object System.Windows.Forms.ImageList 
$imageList.ImageSize = New-Object System.Drawing.Size(30,30) 
$bitm1=[System.Drawing.Image]::FromFile("$icoontjesmap\explorer-icoon.png")
$bitm2=[System.Drawing.Image]::FromFile("$icoontjesmap\file-icoon.png")
$imageList.Images.Add("explorer", $bitm1) 
$imageList.Images.Add("file", $bitm2) 

$global:listView1 = New-Object System.Windows.Forms.ListView
$listView1.View = 'Details'
$listView1.Height = 278
$listView1.Width = 330
$listView1.Font = New-Object System.Drawing.Font("MS Sans Serif",12)
# zorgen dat selectie zichtbaar blijft.
$listview1.HideSelection = $false

# $listView1.AutoResizeColumns(1) 
 
$System_Drawing_Point = New-Object System.Drawing.Point
$System_Drawing_Point.X = 200
$System_Drawing_Point.Y = 245
 
$listView1.Location = $System_Drawing_Point
$listView1.Name = "listView1"
$listView1.Sorting = 'Ascending'
$listView1.Columns.Add('Inhoud examenmap',600)| Out-Null
# hieronder toch niet nodig. geeft geen effect.
# $listView1.AutoResizeColumns(1)
$listView1.SmallImageList = $imageList
$listView1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer eventueel alleen de bestanden en mappen die je wilt overzetten. 
Klik op een map om de inhoud rechts weer te geven." )
})


# bij aanklikken van een map, inhoud weergeven in venster ernaast
$listView1.add_SelectedIndexChanged(
     { 
     # selectie krijgt waarde van volledige pad naar gekozen map
     $selectie = $digitalebestanden
     foreach ($item in $geselecteerdebronmap) {
                $selectie = -join ($selectie, '\', $item)
          }
     $selectie = -join ($selectie, '\', $listView1.SelectedItems.text)

     # alleen als 1 item is geselecteerd en de item moet een map zijn.
     if (( $listView1.selecteditems.count -eq 1) -and ((test-path -path $selectie -pathtype container) -eq $true) ) {

          # tekstbox legen
          $listView2.items.clear()

          # weergeven inhoud in rechter venster, inhoud geselecteerde map
          $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

          # dan netjes in rijen plaatsen.
          foreach ($item in $folders) {
               if (( test-path -path "$selectie\$item" -pathtype container) -eq $true)  {
                    [void] $listView2.Items.Add($item, 0)
                    } else {
                    [void] $listView2.Items.Add($item, 1)
                    }
               }
          # aanpassen vesnter aan inhoud
          $listView2.AutoResizeColumns(1) 
          startknopklikbaar;

          } else {
          # venster met inhoud map legen
          $listView2.items.clear()
          }
    }
    )


# bij dubbelklikken van een map, map selecteren en openen
# hier wordt echter alleen 1 van de dropdownmenu's geactiveerd die dit gaat uitvoeren.
$listView1.add_doubleClick(
     {
     # selectie krijgt waarde van volledige pad naar gekozen map
     $selectie = $digitalebestanden
     foreach ($item in $geselecteerdebronmap) {
                $selectie = -join ($selectie, '\', $item)
                }
     $selectie = -join ($selectie, '\', $listView1.SelectedItems.text)
      
     # Er moet een item geselecteerd zijn (je kan namelijk ook dubbelklikken op een lege plek) en de item moet een map zijn.
     # if (($listView1.SelectedIndex -ge 0) -and ((test-path -path $selectie -pathtype container) -eq $true) ) {
     if ((test-path -path $selectie -pathtype container) -eq $true) {

        # als geselecteerde aanwijzen aan een van de dropdownmenu's
        switch ($geselecteerdebronmap.count) {
           "0" { $lijstcrebonrs.selectedindex = $listView1.SelectedIndices[0] }
           "1" { $lijstkerntaken.selectedindex = $listView1.SelectedIndices[0] }
           "2" { $lijstexamens.selectedindex = $listView1.SelectedIndices[0] }
           Default {
                
                # inlezen gekozen map en in variabele plaatsen
                $folders = Get-ChildItem -Path "$selectie"  -Name | Sort-object 

                if ($folders.count -gt 0) {
                    # venster met inhoud map legen
                    $listView2.items.clear()
                    # standaard tekst in venster met geselecteerd examenmap
                    $objtekst2.Text = $Startexamenmap
                    # toevoegen aan lijst geselecteerde mappen
                    $geselecteerdebronmap.Add($listView1.SelectedItems.text)
                    # leegmaken huidige venster 
                    $listView1.items.clear()
                    # toevoegen aan geselecteerde examenmap
                    foreach ($item in $geselecteerdebronmap) {
                        $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $Item)
                        }

                    # toevoegen aan venster
                    foreach($folder in $folders){ toevoegen_lijst1 $selectie $folder  }
                    # breedte listview1 aanpassen aan de inhoud
                    $listView1.AutoResizeColumns(1) 
                    startknopklikbaar;
                } # if ($folders.count -gt 0)
           } # einde default switch keuze
        }  #einde switch

      }   # einde if (test-path -path $selectie -pathtype container)
     } )

$listView2 = New-Object System.Windows.Forms.ListView
$listView2.View = 'Details'
$listView2.Height = 278
$listView2.Width = 350
$listView2.Font = New-Object System.Drawing.Font("MS Sans Serif",12)
# zorgen dat selectie zichtbaar blijft.
$listview2.MultiSelect = $false
 
$System_Drawing_Point2 = New-Object System.Drawing.Point
$System_Drawing_Point2.X = 530
$System_Drawing_Point2.Y = 245
 
$listView2.Location = $System_Drawing_Point2
$listView2.Name = "listView2"
$listView2.Sorting = 'Ascending'
$listView2.Columns.Add('Inhoud geselecterde examenmap',600)| Out-Null
# hieronder toch niet nodig. geeft geen effect.
# $listView1.AutoResizeColumns(1)
$listView2.SmallImageList = $imageList
$listView2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Dit is de inhoud van de geselecteerde map." )
})

$listView2.add_SelectedIndexChanged( { 
  $listview2.SelectedItems.Clear()
  } )

# standaard tekst in venster met geselecteerd examenmap
$Startexamenmap = "Examenmap"
# Tekst tussen twee geselecteerde mappen, om deze uit elkaar te houden
$Scheidingstekst = "  "

$objtekst2 = New-Object System.Windows.Forms.textbox
$objtekst2.Location = New-Object System.Drawing.Size(200,200) 
$objtekst2.Size = New-Object System.Drawing.Size(680,47)
$objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
# $objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12,[System.Drawing.FontStyle]::Bold)
$objtekst2.Text = $Startexamenmap
# $objtekst2.Text = "Examenmap met een heleboel tekst om t etestemn of dze wel goed zichtbaar is en natuulijk hoe het ruit gaat zien met de nieuwe indelibng die ik voor ogen hebt!!! En nu nog meer tekst om te testen hoe de 3e regel erop komt gggjjjqqqyy"
$objtekst2.ReadOnly = $true
$objtekst2.Multiline = $true
# $objtekst2.ScrollBars = "Horizontal"
$objtekst2.BackColor  = 'white'
$objtekst2.Forecolor  = 'blue'
$objtekst2.WordWrap = $true
$objtekst2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Hier zie je de huidige geselecteerde examenmap." )
})

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Locatie"
$lijstlocaties.width               = 330
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,40) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0

foreach( $property in $global:beheer.locaties.psobject.properties.name ) {

    $waarde=$global:beheer.locaties.$property.naam
    [void] $lijstlocaties.Items.Add("$property - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($property -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     startknopklikbaar;
     } ) 

$lijstcrebonrs                     = New-Object system.Windows.Forms.ComboBox
$lijstcrebonrs.text                = "Crebonummer"
$lijstcrebonrs.width               = 330
$lijstcrebonrs.autosize            = $true
$lijstcrebonrs.Location = New-Object System.Drawing.Size(200,80) 
$lijstcrebonrs.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstcrebonrs.DropDownStyle="DropDownList"
$lijstcrebonrs.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de crebonummer." )
})


# crebonummers in de dropdownlijst zetten. Deze lijst verandert niet.
# en weergeven in venster listview1. Deze lijst verandert wel.
Get-ChildItem -Path $digitalebestanden -Name | Sort-object | ForEach-Object {
    [void] $lijstcrebonrs.Items.Add($_)
    toevoegen_lijst1 $digitalebestanden $_ 
    }
# breedte listview1 aanpassen aan de inhoud
$listView1.AutoResizeColumns(1) 

# uitvoeren als selectie van crebonummer wijzigt
$lijstcrebonrs.add_SelectedIndexChanged(
     { 
      
      # alleen als er geselecteerd is 
      if ($lijstcrebonrs.SelectedIndex -ge 0) {
        # venster met inhoud map legen
        $listView2.items.clear()

        <# toevoegen aan lijst geselecteerde mappen
           array wordt leeggemaakt omdat je inhoud geeft aan de 1e item aan de array "geselecteerdebronmap"
        #>
        $geselecteerdebronmap.Clear()

        # leegmaken huidige venster en dropdownmenu's
        $listView1.items.clear()
        $lijstkerntaken.items.clear()
        $lijstexamens.items.clear()
        $objtekst2.Text = $Startexamenmap

        # selectie krijgt waarde van gekozen crebonummer
        $selectie = -join ($digitalebestanden, '\', $lijstcrebonrs.SelectedItem)

        # als gekozen item een map is dan toevoegen aan lijst en weergeven in venster en in dropdownmenu
        # anders selecteren van hoofdmap en deze weergeven in venster
        if ((test-path -path $selectie -pathtype container) -eq $true) {
            # toevoegen aan lijst geselecteerde mappen 
            $geselecteerdebronmap.Add($lijstcrebonrs.SelectedItem)

            # Toevoegen aan geselecteerde examenmap
            $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $lijstcrebonrs.SelectedItem)

            # inlezen gekozen map en in variabele plaatsen
            $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

            # toevoegen aan betreffende dropdown lijst en aan venster in het midden.
            foreach($folder in $folders) {
                $lijstkerntaken.Items.Add($folder)
                toevoegen_lijst1 $selectie $folder
                # $listView1.AutoResizeColumns(1)
                }
            } else {
            # selectie leeg maken
            $lijstcrebonrs.selectedindex = -1
            # hoofdmap selecteren om weer te geven
            $selectie = $digitalebestanden

            # inlezen gekozen map en in variabele plaatsen
            $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

            # toevoegen aan venster in het midden.
            foreach($folder in $folders) {
                toevoegen_lijst1 $selectie $folder
                }
            }
     # breedte listview1 aanpassen aan de inhoud
     $listView1.AutoResizeColumns(1)

     startknopklikbaar;
     } else { 
       $lijstcrebonrs.selectedindex = -1
     } 
     # einde ($lijstkerntaken.SelectedIndex -ge 0) .. else
     } )


$lijstkerntaken                     = New-Object system.Windows.Forms.ComboBox
$lijstkerntaken.text                = "Kerntaak"
$lijstkerntaken.width               = 330
$lijstkerntaken.autosize            = $true
$lijstkerntaken.Location = New-Object System.Drawing.Size(200,120) 
$lijstkerntaken.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstkerntaken.DropDownStyle="DropDownList"
$lijstkerntaken.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de kerntaak." )
})


# uitvoeren als selectie van kerntaken wijzigt
 $lijstkerntaken.add_SelectedIndexChanged(
    {
      

      if ($lijstkerntaken.SelectedIndex -ge 0) {

        # venster met inhoud map legen
        $listView2.items.clear()

        # leegmaken huidige venster en dropdownmenu's
        $listView1.items.clear()
        $lijstexamens.items.clear()
        $objtekst2.Text = $Startexamenmap

        <# controleren of een aantal geselecteerde mappen verwijderd moeten worden. Dit komt voor als je al mappen hebt geselecteerd en terug gaat.
           verwvanaf =1 omdat hiermee de 2e item in de array wordt aangesproken
        #>
        $verwvanaf = 1
        [int] $aantal = $geselecteerdebronmap.count -$verwvanaf
        if ($geselecteerdebronmap.count -gt $verwvanaf) { $geselecteerdebronmap.RemoveRange($verwvanaf,$aantal) }

        # selectie krijgt waarde van gekozen kerntaak
        $selectie = -join ($digitalebestanden, '\', $geselecteerdebronmap[0], '\', $lijstkerntaken.SelectedItem)

        # Toevoegen aan geselecteerde examenmap
        $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $geselecteerdebronmap[0])

        # inlezen gekozen map en in variabele plaatsen
        $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

        # controle of geselecteerde een map is of een bestand
        if ((test-path -path $selectie -pathtype container) -eq $true) {
            # en dan nu pas toevoegen
            $geselecteerdebronmap.Add($lijstkerntaken.SelectedItem)
        
            # Toevoegen aan geselecteerde examenmap
            $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $lijstkerntaken.SelectedItem)

            # toevoegen aan betreffende dropdown lijst
            foreach($folder in $folders){
                $lijstexamens.Items.Add($folder)
                }
        } else {
            # selectie leeg maken
            $lijstkerntaken.selectedindex = -1

            # selectie krijgt waarde van eerder gekozen crebonr
            $selectie = -join ($digitalebestanden, '\', $geselecteerdebronmap[0])
            # opnieuw inlezen gekozen map en in variabele plaatsen
            $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 
        }
        
        # toevoegen aan venster in het midden. 
        foreach($folder in $folders){
           toevoegen_lijst1 $selectie $folder
           }
        # breedte listview1 aanpassen aan de inhoud
        $listView1.AutoResizeColumns(1)
        startknopklikbaar;
    } # einde ($lijstkerntaken.SelectedIndex -ge 0)
    } )

$lijstexamens                     = New-Object system.Windows.Forms.ComboBox
$lijstexamens.text                = "Examen"
$lijstexamens.width               = 330
$lijstexamens.autosize            = $true
$lijstexamens.Location = New-Object System.Drawing.Size(200,160) 
$lijstexamens.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstexamens.DropDownStyle="DropDownList"
$lijstexamens.Name =  "Kies een examen"
$lijstexamens.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het examen." )
})


# uitvoeren als selectie van examens wijzigt
$lijstexamens.add_SelectedIndexChanged(
    {
      if ($lijstexamens.SelectedIndex -ge 0) {
      
        # venster met inhoud map legen
        $listView2.items.clear()

        # leegmaken huidige vensters
        $listView1.items.clear()
        $objtekst2.Text = $Startexamenmap

        <# controleren of een aantal geselecteerde mappen verwijderd moeten worden. Dit komt voor als je al mappen hebt geselecteerd en terug gaat.
           verwvanaf = 2 omdat hiermee de 3e item in de array wordt aangesproken.
        #>
        $verwvanaf = 2
        [int] $aantal = $geselecteerdebronmap.count -$verwvanaf
        if ($geselecteerdebronmap.count -gt $verwvanaf) { $geselecteerdebronmap.RemoveRange($verwvanaf,$aantal) }

        # selectie krijgt waarde van gekozen examen
        $selectie = -join ($digitalebestanden, '\', $geselecteerdebronmap[0], '\', $geselecteerdebronmap[1], '\', $lijstexamens.SelectedItem)

        # Toevoegen aan geselecteerde examenmap
        $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $geselecteerdebronmap[0], $Scheidingstekst, $geselecteerdebronmap[1])

        # inlezen gekozen map en in variabele plaatsen
        $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 

        # controle of geselecteerde een map is of een bestand
        if ((test-path -path $selectie -pathtype container) -eq $true) {
            # en dan nu pas toevoegen
            $geselecteerdebronmap.Add($lijstexamens.SelectedItem)

            # Toevoegen aan geselecteerde examenmap
            $objtekst2.Text = -join ($objtekst2.Text, $Scheidingstekst, $lijstexamens.SelectedItem)
        } else {
            # selectie leeg maken
            $lijstexamens.selectedindex = -1

            # selectie krijgt waarde van eerder gekozen kerntaak
            $selectie = -join ($digitalebestanden, '\', $geselecteerdebronmap[0], '\', $geselecteerdebronmap[1])

            # inlezen gekozen map en in variabele plaatsen
            $folders = Get-ChildItem -Path "$selectie" -Name | Sort-object 
        }

        # toevoegen aan venster
        foreach($folder in $folders){
           toevoegen_lijst1 $selectie $folder
           }
        # breedte listview1 aanpassen aan de inhoud
        $listView1.AutoResizeColumns(1)
        startknopklikbaar;
    }  # einde if ($lijstexamens.SelectedIndex -ge 0)
    } )

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Bestanden overzetten." 690 320 520 550 "Met de taak Bestanden overzetten worden bestanden overgezet naar de RPC-nummers.
In het linkerkolom selecteert u de RPC-nummers waar de bestanden naar toe worden overgezet.
In het midden selecteert u de locatie, crebonummer, kerntaak en examen.

U kunt ook 'door de mappen bladeren' door dubbel te klikken op een map in het middelste kolom.

Eventueel kunt u ervoor kiezen om alleen enkele mappen over te zetten.
Hiertoe moet u in het vakje onderaan deze bestanden of mappen selecteren, 
met een enkele muisklik of met de CTRL-toets in combinatie met een muisklik.

Als u op een map klikt in het vakje onderaan wordt de inhoud hiervan rechts weergegeven.

Om naar het overzicht te gaan waar u het overzetten kan starten moet u op Bevestigen klikken.
"

startknopklikbaar;

$Form2.controls.AddRange(@($listBox, $lijstlocaties, $lijstcrebonrs, $lijstkerntaken, $lijstexamens, $objtekst2, $BtnTerug, $BtnOpnieuw, $listview1, $listView2, $Btnstart, $Btnescape, $Description2,
$Description3, $Description4, $Description5, $Description8, $Global:vraagtekenicoon ))

#$form2.Topmost = $true
$form2.Topmost = $false

# venster tonen
$null = $form2.ShowDialog()
    
$form2.close();
# $form2.hide();

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensterkopieren

function vensterbackup {
# taak backuppen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]
# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$homemapstudenten = $global:beheer.examenmappen.homemapstudenten
$backupmap = $global:beheer.examenmappen.backupmap

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten" )) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

if (!(test-path -path "$backupmap" )) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$Form2 = declareren_standaardvenster "Backup van bestanden in de studentmappen" 450 680

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(290,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "RPC-nummers"
$Description4.AutoSize            = $false
$Description4.width               = 800
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(290,55)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "backup" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,55)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 475
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waarvan de backup wordt gemaakt." )
})

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$wissennabackup = New-Object System.Windows.Forms.Checkbox 
$wissennabackup.Location = New-Object System.Drawing.Point(50,580)
$wissennabackup.Size = New-Object System.Drawing.Size(300,30)
$wissennabackup.Text = "Bestanden na de backup ook wissen"
$wissennabackup.Font = 'Microsoft Sans Serif,11'
$wissennabackup.ForeColor = [System.Drawing.Color]::green
$wissennabackup.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of de bestanden in de studentmappen na de backup worden gewist." )
})

if (($global:init["algemeen"]["wissennabackup"]) -eq "Ja") {
    $wissennabackup.checked = $true
    } else {
    $wissennabackup.checked = $false
    }

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,15) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0

foreach( $property in $global:beheer.locaties.psobject.properties.name ) {

    $waarde=$global:beheer.locaties.$property.naam
    [void] $lijstlocaties.Items.Add("$property - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($property -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Backup maken." 730 230 400 590 "Met de taak Backup maken wordt een backup gemaakt van de geselecteerde RPC-nummers.
Bovenaan kunt u de locatie en daaronder de RPC-nummers waarvan een backup gemaakt moet worden, selecteren.

Eventueel kunt u ervoor kiezen om na de backup de bestanden op de studentenpc's te wissen.
Hiertoe moet u een vinkje zetten voor de bijbehorende tekst onderaan.

Om naar het overzicht te gaan waar u de backup kan starten moet u op Bevestigen klikken.
"

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $wissennabackup, $Description3, $Description4, $Global:vraagtekenicoon ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
} # einde vensterbackup

function vensterwissen {
# taak wissen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]
# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$homemapstudenten = $global:beheer.examenmappen.homemapstudenten

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$Form2 = declareren_standaardvenster "Wissen van bestanden in de studentmappen" 480 640;

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Locatie"
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(290,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "RPC-nummers"
$Description4.AutoSize            = $false
$Description4.width               = 800
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(290,55)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue


$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "wissen" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})


# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,55)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 475
$listBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de RPC-nummers waarvan de backup wordt gemaakt." )
})

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,15) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie." )
})

# locaties toevoegen aan lijst
$teller=0
foreach( $property in $global:beheer.locaties.psobject.properties.name ) {

    $waarde=$global:beheer.locaties.$property.naam
    [void] $lijstlocaties.Items.Add("$property - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($property -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Wissen." 690 180 430 550 "Met de taak Wissen worden bestanden van de geselecteerde RPC-nummers verwijderd.
Bovenaan kunt u de locatie en daaronder de RPC-nummers die verwijderd moet worden, selecteren.

Om naar het overzicht te gaan waar u het verwijderen kan starten moet u op Bevestigen klikken.
"

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $Description3, $Description4, $Global:vraagtekenicoon))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdvenster zichtbaar maken
$form.show()
} # einde vensterwissen

function vensterverplaatsen {
# taak verplaatsen van bestanden begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

$keuzedoelmaplegen=$global:init["algemeen"]["maplegenvoorverplaatsen"]

# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$homemapstudenten = $global:beheer.examenmappen.homemapstudenten


# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :
- $homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Verplaatsen of kopiren van bestanden naar een andere studentmap" 550 380;

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Bron"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 50
$Description2.location            = New-Object System.Drawing.Point(300,120)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Doel"
$Description3.AutoSize            = $false
$Description3.width               = 150
$Description3.height              = 50
$Description3.location            = New-Object System.Drawing.Point(300,170)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Locatie"
$Description5.AutoSize            = $false
$Description5.width               = 300
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(300,20)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Taak"
$Description6.AutoSize            = $false
$Description6.width               = 300
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(300,70)
$Description6.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,270" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "verplaatsen" }) 
$Btnstart.Enabled= $false
$Btnstart.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,270" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})
$form2.cancelbutton = $Btnescape

# de selectie vd de bron
$bronselectie                     = New-Object system.Windows.Forms.ComboBox
$bronselectie.width               = 260
$bronselectie.autosize            = $true
$bronselectie.DropDownStyle       = "DropDownList"
$bronselectie.Font                = 'Microsoft Sans Serif,12'
$bronselectie.location = "20,120" 
$bronselectie.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het rpc-nummer met de bronbestanden." )
})
$bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie

#  de selectie vd de doel rpc-nummer 
$doelselectie                     = New-Object system.Windows.Forms.ComboBox
$doelselectie.width               = 260
$doelselectie.autosize            = $true
$doelselectie.DropDownStyle       = "DropDownList"
$doelselectie.Font                = 'Microsoft Sans Serif,12'
$doelselectie.location = "20,170" 
$doelselectie.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer het rpc-nummer waar de bestanden naar toe moeten." )
})
$doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

#  de keuze vd taak
$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 260
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "20,70" 
[void] $keuzeoptie1.Items.Add("Verplaatsen")
[void] $keuzeoptie1.Items.Add("Kopiren")
$keuzeoptie1.Selectedindex = 0
$keuzeoptie1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de uit te voeren taak." )
})


$doelselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $doelselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
    if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$bronselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $bronselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
     if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(20,20) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"
$lijstlocaties.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de locatie voor de rpc-nnummers." )
})

# locaties toevoegen aan lijst
$teller=0
foreach( $property in $global:beheer.locaties.psobject.properties.name ) {

    $waarde=$global:beheer.locaties.$property.naam
    [void] $lijstlocaties.Items.Add("$property - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($property -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie
     $doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

     # selectie van bron en doel ophefen
     $doelselectie.selecteditem = $null
     $bronselectie.selecteditem = $null

     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$doelmaplegen = New-Object System.Windows.Forms.Checkbox 
$doelmaplegen.Location = New-Object System.Drawing.Point(20,220)
$doelmaplegen.Size = New-Object System.Drawing.Size(500,30)
$doelmaplegen.Text = "Doelmap legen voor het verplaatsen of kopiren."
$doelmaplegen.Font = 'Microsoft Sans Serif,12'
$doelmaplegen.ForeColor = [System.Drawing.Color]::Green
if ($keuzedoelmaplegen -eq "Ja") {
    $doelmaplegen.Checked = $true
    } else {
    $doelmaplegen.Checked = $false
    }
$doelmaplegen.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Geef aan of de doelmap geleegd moet worden voor het uitvoeren van de taak." )
})

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over de taak Verplaatsen of Kopiren." 680 280 460 290 "Met de taak Verplaatsen of Kopiren worden bestanden van de geselecteerde RPC-nummer
verplaatst of gekopierd naar een andere RPC-nummer.

Geef aan in welke RPC-nummer de bestanden staan, dit is de bron. 
Dan naar welke RPC-nummer de bestanden worden gekopierd, dat is het doel. 
Eventueel kan de locatie of taak nog worden aangepast.

Als Doelmap legen voor het verplaatsen of kopiren is aangevinkt zal de inhoud van de doelmap 
gewist worden voor het verplaatsen of kopiren.

Om naar het overzicht te gaan waar u het verplaatsen kan starten moet u op Bevestigen klikken."

$form2.controls.AddRange(@($lijstlocaties, $keuzeoptie1, $bronselectie, $doelselectie, $doelmaplegen, $Btnstart, $Btnescape, $Description2, 
$Description3, $Description4, $Description5, $Description6, $Global:vraagtekenicoon ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
} # einde vensterverplaatsen

function programmaafsluiten {
# een venster met de vraag of je het programma wilt sluiten of wilt afmelden

# venster declareren
$formvraag = declareren_standaardvenster "fsluiten of afmelden?" 600 200

$vraaglabel                     = New-Object system.Windows.Forms.Label
$vraaglabel.text                = "
Wilt u het programma afsluiten of de gebruiker afmelden?"
$vraaglabel.AutoSize            = $false
$vraaglabel.width               = 550
$vraaglabel.height              = 100
$vraaglabel.location            = New-Object System.Drawing.Point(20,10)
$vraaglabel.Font                = 'Microsoft Sans Serif,11'
$vraaglabel.ForeColor = [System.Drawing.Color]::Blue
$formvraag.Controls.Add($vraaglabel)

$Afsluiten = New-object System.Windows.Forms.Button 
$Afsluiten.text= "Afsluiten"
$Afsluiten.location = New-Object System.Drawing.Point(50,110)
$Afsluiten.size = "120,30"  
$Afsluiten.BackColor = 'green' 
$Afsluiten.ForeColor = 'white'
$Afsluiten.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$formvraag.Controls.Add($Afsluiten)

$Afmelden = New-object System.Windows.Forms.Button 
$Afmelden.text= "Afmelden"
$Afmelden.location = New-Object System.Drawing.Point(200,110)
$Afmelden.size = "120,30"  
$Afmelden.BackColor = 'blue' 
$Afmelden.ForeColor = 'white'
$Afmelden.DialogResult = [System.Windows.Forms.DialogResult]::ok
$formvraag.Controls.Add($Afmelden)

$vraagescape = New-object System.Windows.Forms.Button 
$vraagescape.text= "Annuleren"
$vraagescape.location = New-Object System.Drawing.Point(350,110)
$vraagescape.size = "120,30"  
$vraagescape.BackColor = 'red'
$vraagescape.ForeColor = 'white'
$vraagescape.DialogResult = [System.Windows.Forms.DialogResult]::yes
$formvraag.Controls.Add($vraagescape)

$result = $formvraag.ShowDialog()
    
$formvraag.close();

return $result

} # einde programmaafsluiten

function vensterlogbestand {

function bepaaldatumuitlognaam ($invoer)
{
<# Uit de invoer wordt de datum bepaald. De format hiervoor staat in functie "bepaallognaam".
  Een wijziging in deze functie moet hier ook worden toegepast.
#>
$jaar = $invoer.substring(4, 4)
$maand = $invoer.substring(9, 2)
$dag = $invoer.substring(12, 2)
$datumintekst = -join ($dag,'-',$maand,'-',$jaar)
return $datumintekst
}


# de taak logbestand bekijken begint hier bij vensterlogbestand

# Deze variabele bepaalt de "weer te geven logbestanden". Dit is is een function geplaatst om op 1 plek veranderingen door te voeren.
$weertegevenlogs = bepaaleigenlogbestanden

# controle of er logbestanden zijn
if (!(Test-Path -Path $weertegevenlogs)) {
    $null = vraagvenster "Geen logbestanden" "
    
Er zijn geen logbestanden om te weergeven."
    return;
    }

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Logbestanden bekijken" 1060 670

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Filter op jaar"
$Description2.AutoSize            = $false
$Description2.width               = 100
$Description2.height              = 42
$Description2.location            = New-Object System.Drawing.Point(20,18)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "en op maand"
$Description3.AutoSize            = $false
$Description3.width               = 100
$Description3.height              = 42
$Description3.location            = New-Object System.Drawing.Point(210,18)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Logbestanden"
$Description4.AutoSize            = $false
$Description4.width               = 120
$Description4.height              = 20
$Description4.location            = New-Object System.Drawing.Point(20,65)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Inhoud van geselecteerde logbestand"
$Description5.AutoSize            = $false
$Description5.width               = 280
$Description5.height              = 20
$Description5.location            = New-Object System.Drawing.Point(160,65)
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.ForeColor = [System.Drawing.Color]::Blue

$filterjaar                     = New-Object system.Windows.Forms.ComboBox
$filterjaar.width               = 70
$filterjaar.autosize            = $true
$filterjaar.DropDownStyle       = "DropDownList"
$filterjaar.Font                = 'Microsoft Sans Serif,12'
$filterjaar.location = "120,15" 
# vullen met jaren
for ($i=2022; $i -le 2040; $i++) {
    [void] $filterjaar.Items.Add($i)
}
$filterjaar.add_SelectedIndexChanged({
    $filtermaand.Enabled = $true
    $filtermaand.selecteditem = $null
    $listbox2.Items.clear()

    Get-ChildItem -Path $weertegevenlogs -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"

        if ($datumlog.Contains($filterjaar.selecteditem)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})
$filterjaar.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Toon alleen de logbestanden van de geselecteerde jaar." )
})

$filtermaand                     = New-Object system.Windows.Forms.ComboBox
$filtermaand.width               = 50
$filtermaand.autosize            = $true
$filtermaand.DropDownStyle       = "DropDownList"
$filtermaand.Font                = 'Microsoft Sans Serif,12'
$filtermaand.location = "320,15" 
$filtermaand.Enabled = $false
# vullen met maanden
for ($i=01; $i -le 12; $i++) {
    if ($i -lt 10) {
        [void] $filtermaand.Items.Add("0$i")
        } else {
        [void] $filtermaand.Items.Add("$i")
        }
}
$filtermaand.add_SelectedIndexChanged({
    $listbox2.Items.clear()

    Get-ChildItem -Path $weertegevenlogs -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"
        $filter = -join ($filtermaand.selecteditem,"-",$filterjaar.selecteditem)
        if ($datumlog.Contains($filter)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})
$filtermaand.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Toon alleen de logbestanden van de geselecteerde maand." )
})

$filterwissen = New-object System.Windows.Forms.Button 
$filterwissen.text= "Filters wissen"
$filterwissen.location = "400,15" 
$filterwissen.size = "150,30"  
$filterwissen.BackColor = 'blue'
$filterwissen.ForeColor = 'white'
$filterwissen.add_click({
    
    $filtermaand.selecteditem = $null
    $filterjaar.selecteditem = $null
    $filtermaand.Enabled = $false

    $listbox2.Items.clear()
    Get-ChildItem -Path $weertegevenlogs -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)        
    }
    # eerste logbestand is geselecteerd.
    $listBox2.SelectedIndex = 0
})
$filterwissen.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Wis alle filters en laat alle logbestanden weer zien." )
})

$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,590" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'red'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Buttenok.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster." )
})

$listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(10,90)
$listBox2.Size = New-Object System.Drawing.Size(120,20)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.Height = 495
$listBox2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Selecteer de datum van het logbestand die u wilt zien." )
})

# bij aanklikken van een datum, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged( {
    $objtekst1.Text = ""
    # datum omzetten naar bestandsnaam
    $gekozendatum = bepaallognaam $ListBox2.SelectedItem
    # inhoud bestand inlezen
    $volledigetext = Get-Content -Path "$gekozendatum"
    # dan netjes in rijen plaatsen.
    foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + "$item" + "`r`n"
               }
    } )

# inhoud van logmap weergeven met listbox2
Get-ChildItem -Path $weertegevenlogs -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)
    }

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(150,90) 
$objtekst1.Size = New-Object System.Drawing.Size(880,484)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'
$objtekst1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Inhoud van het geselecteerde logbestand." )
})

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Logbestanden bekijken." 680 180 500 590 "Als u links de datum van het logbestand dat je wilt bekijken selecteert, dan wordt rechts 
de inhoud weergegeven.

U kunt om sneller een logbestand te vinden, bovenaan filteren op jaar en maand.
Door om de knop Filters wissen te klikken ziet u weer alle logbestanden." 

$Form2.Controls.AddRange(@($Description2, $Description3, $Description4, $Description5, $filterjaar, $filtermaand, $filterwissen, $listbox2, $objtekst1, $Buttenok, $Global:vraagtekenicoon ))

# eerste logbestand is geselecteerd.
$listBox2.SelectedIndex = 0

$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()
} # einde vensterlogbestand

function updatevoorbereiden {
# de taak updaten begint hier

# alleen starten als programma.mode niet de status alpha of beta heeft.
if ("alpha","beta" -contains($global:programma.mode)) {
    return
}

write-host "Controleren of het programma de laatste update heeft."

<# $huidigeversie wordt alleen in deze functie gebruikt en is er om te verduidelijken dat dit de huidge versie is en
   om niet overal "global:" voor te zetten. $versie is namelijk een global variabele.
#>
$huidigeversie = $global:programma.versie

# updaten naar een versie. "uptodate" betekent geen update nodig, 
$updateto="uptodate"

# pad naar updateinfo op lokale pc
$updateinfobestand = -join ("$startmap","\","$global:updateinfo")
# bepalen downloadbestand
$downloadbestand = -join ("$updatewebsite","/updates/","$global:updateinfo")

<# controleren of een update is uitgevoerd en zo ja verwijderen bestand.
   zo kan je niet na een update, opnieuw updaten.
   als dit zo is dan afsluiten.
#>
if (test-path -path $updateinfobestand -pathtype leaf) { 
    Remove-Item "$updateinfobestand" 
    return
    }

# downloaden updateinfobestand van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$updateinfobestand" -ErrorAction Stop
    }
catch {
      write-host "Bestand met update-informatie niet kunnen downloaden! " -f Red
      Start-Sleep -s 3
      return
      }
      
# inlezen updateinfobestand en controleren op een update ...

# inlezen ini-bestand naar object
$updateini = Get-IniContent $updateinfobestand

if ($updateini.count -gt 0) {

# controleren op revisie en anders op laatste versie 
if ($updateini["revision"].Contains($huidigeversie) ) {
    $updateto = $updateini["revision"]["$huidigeversie"]
    } else {
    
    if ("$huidigeversie" -lt $updateini["program"]["latest"]) {
        $updateto = $updateini["program"]["latest"]
        }
} # if $updateini["revision"] .. else
} else {
    $updateto = "foutini"
}# if ($updateini.count -gt 0) ... else

# einde controles. er is bepaald of er een update is.

# programma is up to date?
if ($updateto -eq "uptodate") {
    Remove-Item "$updateinfobestand" 
    return
} elseif ($updateto -eq "foutini") {
    write-host "Er is iets fout gegaan bij het controleren op een update! " -f Red
    Start-Sleep -s 5
    Remove-Item "$updateinfobestand" 
    return
}

# Hier aangekomen dan is er een update beschikbaar.

write-host "Programma wordt gepdatet ..."

# variabelen die nodig zijn voor het downloaden. 
# bestand met update die gedownload wordt
$zip_download = "beherenbestanden_$updateto.zip"
# pad naar bestand met update op de website
$downloadbestand = bepaalversiemap "$updateto"
# pad naar bestand met update op de website, samenvoegen met update die gedownload wordt
$downloadbestand = -join ("$downloadbestand","/","$zip_download")
# pad naar bestand met update op lokale pc
$zip_download = -join ("$startmap","\","$zip_download")

# downloaden zip_download van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$zip_download" -ErrorAction Stop
    }
catch {
    write-host "Bestand met update niet kunnen downloaden! " -f Red
    Start-Sleep -s 5
    Remove-Item "$updateinfobestand" 
    return
    }

# tempmap aanmaken. als deze al bestaat wordt geen melding gegeven.
# vervolgens leeg maken
$tempmap = "$startmap\temp"

mkdir $tempmap -ErrorAction SilentlyContinue 1>$null
Remove-Item "$tempmap\*" -Recurse -Force 

# uitpakken van programma naar tempmap.
Expand-Archive -Path "$zip_download" -DestinationPath "$tempmap" -Force

# zipbestand na het uitpakken direct verwijderen
Remove-Item "$zip_download"

# script gaat zichzelf updaten 
Copy-Item -path "$tempmap\*" -destination "$startmap" -force -ErrorAction Stop
Copy-Item -path "$tempmap\png\*" -destination "$startmap\png" -force -ErrorAction Stop

#schoonmaken temp map
Remove-Item "$tempmap" -Force -Recurse

Write-Host -b White -f Red "Het programma heeft een update uitgevoerd en heeft nu de versie $updateto.
Het programma wordt opnieuw opgestart en u moet dan opnieuw inloggen ..."

Start-Sleep -Seconds 5

# opnieuw opstarten script met een andere procesnummer
# powershell -file "$PSScriptRoot\beherenbestanden.ps1"

start-process PowerShell.exe -argumentlist '-file',".\beherenbestanden.ps1"

# beindigen van programma als updaten is uitgevoerd. Anders kan je na een update niet afsluiten.
 exit;


} # einde updatevoorbereiden

function vensterinstellingen {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# venster declareren
$Form2 = declareren_standaardvenster "Instellingen wijzigen" 600 420

$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 80
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "450,20" 

# locaties toevoegen aan lijst
$teller=0
foreach( $property in $global:beheer.locaties.psobject.properties.name ) {
    # locatiecode toevoegen
    [void] $keuzeoptie1.Items.Add("$property")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($property -eq "$keuzelocatie") { $keuzeoptie1.Selectedindex = $teller }
    $teller++
    }

$keuzeoptie2                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie2.width               = 80
$keuzeoptie2.autosize            = $true
$keuzeoptie2.DropDownStyle       = "DropDownList"
$keuzeoptie2.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie2.location = "450,60" 
[void] $keuzeoptie2.Items.Add("Ja")
[void] $keuzeoptie2.Items.Add("Nee")
if ($global:init["algemeen"]["wissennabackup"] -eq "Ja") {
    $keuzeoptie2.Selectedindex = 0
    } else {
    $keuzeoptie2.Selectedindex = 1
    }

$keuzeoptie3                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie3.width               = 80
$keuzeoptie3.autosize            = $true
$keuzeoptie3.DropDownStyle       = "DropDownList"
$keuzeoptie3.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie3.location = "450,100" 
[void] $keuzeoptie3.Items.Add("Ja")
[void] $keuzeoptie3.Items.Add("Nee")
if ($global:init["algemeen"]["maplegenvoorverplaatsen"] -eq "Ja") {
    $keuzeoptie3.Selectedindex = 0
    } else {
    $keuzeoptie3.Selectedindex = 1
    }

$keuzeoptie4                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie4.width               = 80
$keuzeoptie4.autosize            = $true
$keuzeoptie4.DropDownStyle       = "DropDownList"
$keuzeoptie4.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie4.location = "450,140" 
[void] $keuzeoptie4.Items.Add("Ja")
[void] $keuzeoptie4.Items.Add("Nee")
if ($global:init["opschonen"]["opschonenlogs"] -eq "Ja") {
    $keuzeoptie4.Selectedindex = 0
    } else {
    $keuzeoptie4.Selectedindex = 1
    }

$keuzeoptie5 = New-Object System.Windows.Forms.TextBox 
$keuzeoptie5.Location = New-Object System.Drawing.Size(450,180) 
$keuzeoptie5.Size = New-Object System.Drawing.Size(80,60)
$keuzeoptie5.MaxLength = 4
$keuzeoptie5.Font = 'Microsoft Sans Serif,11'
$keuzeoptie5.Text=$Global:init["opschonen"]["dagenbewarenlogs"]
$keuzeoptie5.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Standaard locatie"
$Description1.AutoSize            = $false
$Description1.width               = 400
$Description1.height              = 30
$Description1.location            = New-Object System.Drawing.Point(40,20)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue
$Description1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Met de standaard locatie wordt bepaald welke rpc-nummers geselecteerd kunnen worden." )
})

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Studentmappen wissen na uitvoeren van een backup"
$Description2.AutoSize            = $false
$Description2.width               = 400
$Description2.height              = 30
$Description2.location            = New-Object System.Drawing.Point(40,60)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue
$Description2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of standaard de optie om de studentmappen te wissen is geselecteerd bij het uitvoeren van een backup." )
})

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Studentmap wissen voor het verplaatsen van bestanden"
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(40,100)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue
$Description3.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of standaard de optie om de studentmap te wissen is geselecteerd bij het verplaatsen van bestanden." )
})

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Automatisch verwijderen oude logbestanden bij de start van het programma"
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(40,140)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue
$Description4.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal of bij het opstarten logbestanden verwijderd worden. Hierbij wordt gebruikt gemaakt van de instelling hieronder." )
})

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Standaard dagen voor het verwijderen van logbestanden van het programma"
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 40
$Description5.location            = New-Object System.Drawing.Point(40,180)
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.ForeColor = [System.Drawing.Color]::Blue
$Description5.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bepaal tot hoeveel dagen de logbestanden bewaard blijven bij het verwijderen van oude logbestanden." )
})

$Btnstandaard = New-object System.Windows.Forms.Button 
$Btnstandaard.text= "Herstel de standaardinstellingen"
$Btnstandaard.location = "50,280" 
$Btnstandaard.size = "250,30"  
$Btnstandaard.BackColor = 'blue'
$Btnstandaard.ForeColor = 'white'
$Btnstandaard.add_click({
    # inlezen ini-bestand naar tijdelijke object
    $temp_init = gebruikersinstellingen

    # alle opties krijgen hun standaard waarde. Er wordt nog niets bewaard!
    $keuzeoptie1.SelectedItem=$temp_init["algemeen"]["locatiekeuze"]
    $keuzeoptie2.SelectedItem=$temp_init["algemeen"]["wissennabackup"]
    $keuzeoptie3.SelectedItem=$temp_init["algemeen"]["maplegenvoorverplaatsen"]
    $keuzeoptie4.SelectedItem=$temp_init["opschonen"]["opschonenlogs"]
    $keuzeoptie5.Text=$temp_init["opschonen"]["dagenbewarenlogs"]
 
}) # einde Btnstandaard.add_click
$Btnstandaard.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Zet alle instellingen terug naar de standaard waarden." )
})

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bewaren"
$Btnaccept.location = "50,330" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.DialogResult = [System.Windows.Forms.DialogResult]::yes
$Btnaccept.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Sla de wijzingen op en ga terug naar het hoofdvenster." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,330" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster zonder de wijzigingen op te slaan." )
})


# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Instellingen." 680 240 540 330 "Wijzig hier de standaard instellingen van het programma.

U krijgt extra informatie over een instelling als de muiscursor op een tekst staat.
U kunt alle instellingen herstellen naar de standaardwaarde door op de knop 
Herstel de standaardinstellingen te klikken.

Als u de instellingen wilt bewaren klikt u op Bewaren.
Als u terug wilt zonder de instellingen te bewaren klikt u op Annuleren.
" 

$Form2.Controls.AddRange(@($keuzeoptie1, $keuzeoptie2, $keuzeoptie3, $keuzeoptie4, $keuzeoptie5, $description1, $description2, $description3, 
$description4, $description5, $Btnstandaard, $Btnaccept, $Btnescape, $Global:vraagtekenicoon ))

# openen venster
$result = $form2.ShowDialog()

# bewaren van instellingen
if ($result -eq [system.windows.forms.dialogResult]::yes) { 

    # keuzes worden ingesteld
    $global:init["algemeen"]["locatiekeuze"]=$keuzeoptie1.Selecteditem
    $global:init["algemeen"]["wissennabackup"]=$keuzeoptie2.Selecteditem
    $global:init["algemeen"]["maplegenvoorverplaatsen"]=$keuzeoptie3.Selecteditem
    $global:init["opschonen"]["opschonenlogs"]=$keuzeoptie4.Selecteditem
    if (!($keuzeoptie5.Text -eq "" )) {
        # eventueel de nullen ervoor weghalen
        [int32]$getal1=$keuzeoptie5.Text
        # alleen als getal niet 0 is wordt de wijging doorgevoerd
        if ($getal1 -gt 0) { $global:init["opschonen"]["dagenbewarenlogs"]=$getal1 }
    }

    # bestand met nieuwe variabele bewaren.
    # Eerst wordt de persoonlijke initialisatiebestand bepaald.
    $gebruikersbestand = bepaalinitnaamgebruiker
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $gebruikersbestand

} # einde bewaren van instellingen

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensterinstellingen

function vensteropschonen {

# inlezen van backupmappen, bepalen aantal te verwijderen mappen en vullen van venster
function inlezenmappen {

# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$backupmap = $global:beheer.examenmappen.backupmap

if ($objTextBox1.Text -eq "") {
    $null = vraagvenster "Geen getal ingevuld" "Vul een geldige getal in voor het aantal dagen verwijderen backups." "OK"
    # $objTextBox1.Text = "0"
    $Btnaccept.Enabled=$false 
    $listBox.items.clear()
    return;
}

# ingevoerde getallen uit de invulbox halen en eventueel de nullen ervoor eruit halen. dit laatste is een controle.
# getal1 is voor de backups
[int32]$getal1=$objTextBox1.Text
$objTextBox1.Text=$getal1.Tostring()

# aantal backups die worden verwijderd tellen
$tellerbackups = 0
# hier wordt er ingelezen, aantal te verwijderen mappen bepaald en venster gevuld.
$listBox.items.clear()
Get-ChildItem -Path "$backupmap" | Where-Object {($_.psiscontainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal1))} | foreach-object {
        $tellerbackups++
        $listbox.Items.Add($_) 
        }
if ($tellerbackups -eq 0 ) { $Btnaccept.Enabled=$false }
    else { $Btnaccept.Enabled=$true }
}
# einde function inlezenmappen

# ------ begin van de function vensteropschonen ---------------------

# beheer-variabelen krijgen hier een verkorte naam tbv leesbaarheid en gebruik in andere functies
$backupmap = $global:beheer.examenmappen.backupmap

if (!(test-path -path "$backupmap" )) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!
Controleer of de volgende map aanwezig is :
- $backupmap

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$Form2 = declareren_standaardvenster "Verwijder gemaakte backups van de studentmappen" 650 600

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Backups van de studentmappen die ouder zijn dan"
$Description1.AutoSize            = $false
$Description1.width               = 360
$Description1.height              = 30
$Description1.location            = New-Object System.Drawing.Point(20,15)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::blue


$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "dagen worden verwijderd."
$Description2.AutoSize            = $false
$Description2.width               = 200
$Description2.height              = 30
$Description2.location            = New-Object System.Drawing.Point(440,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Onderstaande mappen worden verwijderd."
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,85)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Wijzig eventueel het aantal dagen hierboven en klik op Opnieuw inlezen."
$Description4.AutoSize            = $false
$Description4.width               = 800
$Description4.height              = 30
$Description4.location            = New-Object System.Drawing.Point(20,50)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$objTextBox1 = New-Object System.Windows.Forms.TextBox 
$objTextBox1.Location = New-Object System.Drawing.Size(380,13) 
$objTextBox1.Size = New-Object System.Drawing.Size(55,50)
$objTextBox1.MaxLength = 4
$objTextBox1.Font = 'Microsoft Sans Serif,11'
$objTextBox1.Text=$Global:beheer.opschonen.dagenbewarenbackup
$objTextBox1.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})
$objTextBox1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Wijzigen hier eventueel tot hoeveel dagen oud de backups bewaard blijven." )
})

$global:listbox = New-Object System.Windows.Forms.Listbox
$global:listbox.Location = New-Object System.Drawing.Point(20,115)
$global:listbox.Size = New-Object System.Drawing.Size(250,20)
$global:listbox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$global:listbox.Height = 400
$global:listbox.SelectionMode = 0
$global:listbox.HorizontalScrollbar = $true

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bevestigen"
$Btnaccept.location = "50,510" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.add_click({ 
    inlezenmappen
    if ($Btnaccept.Enabled) { overzichttaken "opschonen"} 
    })

# alleen klikbaar als aantal gevonden bestanden hoger is dan 0
if ($tellerbackups -eq 0 ) { $Btnaccept.Enabled=$false }
    
$Btnaccept.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bevestig je keuze en ga door naar het overzicht." )
})

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,510" 
$Btnescape.size = "150,30"
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$Btnescape.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Annuleer de taak en ga terug naar het hoofdvenster." )
})

$BtInlezen = New-object System.Windows.Forms.Button 
$BtInlezen.text= "Opnieuw inlezen"
$BtInlezen.location = "300,115" 
$BtInlezen.size = "150,30"  
$BtInlezen.BackColor = 'blue'
$BtInlezen.ForeColor = 'white'
$BtInlezen.add_click({ 
    inlezenmappen
    })
# $BtInlezen.Enabled=$false
$BtInlezen.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Opnieuw inlezen van de mappen als het aantal dagen is gewijzigd." )
})

# venster met uitleg over deze taak wordt gedeclareerd.
declareren_uitlegvenster "Uitleg over het venster Verwijder oude backups en oude logbestanden." 680 200 450 510 "Hier kunnen oude backups van de studentmappen verwijderd worden.
In het venster zie je een overzicht van de mappen die vewijderd worden met de huidige 
instellingen.
Wijzigen eventueel tot hoeveel dagen oud de bestanden bewaard blijven en klik op 
Opnieuw inlezen.
Om naar het overzicht te gaan waar u het verwijderen kan starten moet u op Bevestigen klikken." 


$Form2.Controls.AddRange(@( $objTextBox1, $global:listbox, $description1, $description2, $description3, $description4,  $BtInlezen, $Btnaccept, $Btnescape, $Global:vraagtekenicoon ))


# eerst inlezen mappen
inlezenmappen;

# openen venster
$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()

} # einde vensteropschonen

function info_venster_vullen ($keuze) {

# infovenster en tijdelijke object legen. wordt gebruikt bij function informatieprogramma
$objtekst1.Text = "Het bestand wordt geladen ..."
$objtekst_temp.text = ""

# inhoud bestand inlezen
if ($keuze -eq "readme") { 
    $volledigetext = Get-Content -Path "$tempreadmebestand"
    } else {
    $volledigetext = Get-Content -Path "$tempchangelogbestand"
    }

# dan netjes in rijen plaatsen.
foreach ($item in $volledigetext) {
               $objtekst_temp.Text = $objtekst_temp.Text + "$item" + "`r`n"
               }

$objtekst1.Text = $objtekst_temp.text 
} # einde info_venster_vullen

function informatieprogramma {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# aangeven wat de inhoud is van de infovenster, readme of changelog
$global:infovenster = "changelog"

# venster declareren
$Form2 = declareren_standaardvenster "Informatie over het programma" 960 690

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Naam van het programma :
Versie : 
Build :
Progammeur :
Afbeeldingen :"

$Description2.AutoSize            = $false
$Description2.width               = 300
$Description2.height              = 100
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$versie = $global:programma.versie
$extralabel = $global:programma.extralabel
$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Beherenbestanden
$versie
$extralabel
Benvindo Neves
Marco Laluan"

$Description3.AutoSize            = $false
$Description3.width               = 200
$Description3.height              = 100
$Description3.location            = New-Object System.Drawing.Point(330,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue


$Btninfovenster = New-object System.Windows.Forms.Button 
#$Btninfovenster.text= "Changelog bekijken"
$Btninfovenster.location = "230,600" 
$Btninfovenster.size = "180,30"  
$Btninfovenster.BackColor = 'blue'
$Btninfovenster.ForeColor = 'white'
if ($global:infovenster -eq "readme") { 
        $Btninfovenster.text= "Changelog bekijken"
        } else { 
        $Btninfovenster.text= "Readme bekijken"
        } 
$Btninfovenster.add_click({ 
    if ($global:infovenster -eq "readme") { 
        $global:infovenster="changelog" 
        $Btninfovenster.text= "Readme bekijken"
        } else { 
        $global:infovenster="readme" 
        $Btninfovenster.text= "Changelog bekijken"
        } 
    # infovenster vullen met infobestand
    info_venster_vullen $global:infovenster
})
$Btninfovenster.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Verander de inhoud van het informatievakje tussen Readme en Changelog." )
})


$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,600" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'red'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Buttenok.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster." )
})

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,115) 
$objtekst1.Size = New-Object System.Drawing.Size(920,475)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.BackColor  = 'white'

# dit object maakt dat het laden van het bestand en laten zien in het venster sneller gaat
# zie ook function info_venster_vullen
$objtekst_temp = New-Object System.Windows.Forms.textbox


# tijdelijke bestanden benoemen
$tempreadmebestand="$startmap\temp_$readmebestand"
$tempchangelogbestand="$startmap\temp_$changelogbestand"

# downloaden readmebestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$readmebestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempreadmebestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen readme gevonden" "Het is niet gelukt om het readme-bestand te downloaden." "Sluiten" 
    "Het readme-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempreadmebestand"
}
# downloaden changelogbestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$changelogbestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempchangelogbestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen changelog gevonden" "Het is niet gelukt om het changelog-bestand te downloaden." "Sluiten" 
    "Het changelog-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempchangelogbestand"
}

# infovenster vullen met infobestand
info_venster_vullen $global:infovenster

# venster met uitleg over deze taak wordt gedeclareerd. hieronder worden enkele variabelen aangepast aan deze taakvenster
declareren_uitlegvenster "Uitleg over het venster Informatie over het programma." 680 250 500 600 "Bovenaan ziet u enkele gegevens over dit programma.

In het grote vakje kunt u eventueel de readme- of de changelog-bestand bekijken.
De README-bestand is een bestand die eerst gelezen moet worden, voorafgaand aan compilatie, installatie of eerste gebruik.
De CHANGELOG-bestand is een bestand met de wijzigingen per versie.

Door op de blauwe knop onderaan te klikken wijzigt u de inhoud." 

$Form2.Controls.AddRange(@($Description2, $Description3, $Buttenok, $Btninfovenster, $objtekst1, $Global:vraagtekenicoon))

# venster starten
$null = $form2.ShowDialog()

# temp bestanden verwijderen
Remove-Item "$tempreadmebestand" -force
Remove-Item "$tempchangelogbestand" -force

# De hoofdmenu zichtbaar maken
$form.show()
} # einde informatieprogramma

function opschonenlogsbijstart {

# alleen starten als dit is ingesteld in opschonenlogs en programma.mode niet de status alpha of beta heeft.
if (($global:init.opschonen.opschonenlogs -eq "Nee") -or ("alpha","beta" -contains($global:programma.mode)) ) {
    return;
}

# controleren of map met logbestanden bestaat
if (!(test-path -path "$logmap")) {
return;
}


# Deze variabele bepaalt de "weer te geven logbestanden". Dit is is een function geplaatst om op 1 plek veranderingen door te voeren.
$weertegevenlogs = bepaaleigenlogbestanden

# aantal dagen dat bestanden bewaard blijven uit object halen
[int32]$getal2 = $global:init.opschonen.dagenbewarenlogs

# aantal eigen logbestanden die worden verwijderd tellen
$tellerlogs=0
Get-ChildItem -Path $weertegevenlogs | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        $tellerlogs++
}
# Stoppen als er niets is om te verwijderen
if ( $tellerlogs -eq 0) {
    return;
}

# start proces verwijderen

Write-Host "Opschonen van oude logbestanden."

# tijdelijk logbestand bepalen
$tijdelijkelog = "tijdelijkelog.txt"

# logbestandsnaam definiren en volledige pad naar bestand invoeren
$logbestand = -join ("$logmap","\",$tijdelijkelog)

# starttijd van loggen naar variabele
$logtijd = bepaaltijd

#foutmelding voor logbestand
$foutmelding_log="[ FOUT ] "

# in logbestand schrijven
"Het opschonen van logbestanden is gestart." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append

# in logbestand info schrijven
"De volgende $tellerlogs logbestanden ouder dan $getal2 dagen verwijderen : " | out-file $logbestand -Append

# bepaal de lijst met mappen die verwijderd worden
 Get-ChildItem -Path $weertegevenlogs | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        # map om te verwijderen
        $todelete = $_.Name
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append

        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()

        try {
            Remove-Item "$logmap\$todelete" -force -ErrorAction Stop 
           
            }

        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
              } # einde try catch
} # einde get-childitem

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
# alleen uitvoeren als aantal dagen verwijderen logs > 0. Zo wordt alles verwijderd als je dit als 0 instelt.
if ( $getal2 -gt 0) {
    $logtijd = bepaaltijd

    "" | out-file $logbestand -Append
    "Eindtijd  : $logtijd" | out-file $logbestand -Append
    " -------------------------------------------------------------------------" | out-file $logbestand -Append
    "" | out-file $logbestand -Append

    # tijdelijke log toevoegen aan eigen logbestand als deze al bestaat, anders bestand hernoemen.
    Logbestandtoevoegen $logbestand

} # einde if 

} # einde opschonenlogsbijstart

function Venstermetgrap {
# Een venster verschijnt met een grap of een leuke weetje

function laadgrap {
# een random grap ophalen en in tekst-variabele plaatsen
$quote = Invoke-RestMethod -Method Get -Uri 'https://moppenbot.nl/api/random/' 
$tekst = $quote.joke.joke

return $tekst
}

#venster aanmaken
$Form2 = declareren_standaardvenster "De moppenbot" 900 300;

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,20) 
$objtekst1.Size = New-Object System.Drawing.Size(850,180)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = laadgrap
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.TabStop = $false
#$objtekst1.ScrollBars = "Both"
$objtekst1.ScrollBars = 'vertical'
$objtekst1.BackColor  = 'white'
$Form2.Controls.Add($objtekst1);

$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,210" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'red'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Buttenok.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Ga terug naar het hoofdvenster." )
})
$Form2.Controls.Add($Buttenok);

$reload = New-object System.Windows.Forms.Button 
$reload.text= "Nog een grap"
$reload.location = "250,210" 
$reload.size = "150,30"  
$reload.BackColor = 'green'
$reload.ForeColor = 'white'
$reload.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Nog een grap genereren." )
})
$reload.add_click({
    $objtekst1.Text = laadgrap
})
$Form2.Controls.Add($reload);

# venster starten
$null = $form2.ShowDialog()

} # einde functie Venstermetgrap

<# ---------------------      Start en inloggen in programma ---------------------------------------------------------------


#>

write-host "Controleren of benodigde modules aanwezig zijn."

 # Powershell module importeren als deze niet aanwezig is
if (!(Get-Module -name pnp.powershell -ListAvailable)) {
    # zorgen dat modules uit deze repository worden vertrouwd
    Set-PSRepository -Name 'PSGallery' -InstallationPolicy Trusted
    
    write-host "SharePoint module wordt genstalleerd."

    # Install-Module -Name pnp.powershell -Scope CurrentUser
    Install-Module PnP.PowerShell -RequiredVersion 1.12 -Force -scope currentuser

    # voor de veiligheid dit weer terugzetten!
    Set-PSRepository -Name 'PSGallery' -InstallationPolicy untrusted
    }

write-host "Inloggen via Multi-Factor Authentication."

# inloggen via mfa naar Sharepoint
VerbindSharepoint;

# afsluiten als je niet bent ingelogd.
if (!($global:Sharepoint.ingelogd)) { exit; }



# initialiseren van programma 

write-host "Beheerinstellingen van Sharepoint halen en inlezen."

# downloaden beheer instellingen van SharePoint en foutmelding opvangen
try {
 
    $download = -join ($global:Sharepoint.beheermap,'/', $global:Sharepoint.beheerini)
    # Get-PnPFile -Url $download -path $startmap -filename $global:Sharepoint.beheerini -AsFile -force -ErrorAction Stop
    Get-PnPFile -Url $download -path $startmap -filename $global:Sharepoint.beheerini -AsFile -force -ErrorAction Stop
    }

catch {
    # foutmelding weergeven en stoppen
    write-host "Het programma wordt afgesloten omdat de beheerinstellingen niet zijn gevonden op de RPC SharePoint-site. 
Neem contact op met de sitebeheerder van de RPC SharePoint-site."  -f Red
    Start-Sleep -Seconds 8
    exit;
    }

# beheerinstellingen inlezen en locaties naar variabele $locaties brengen
if (test-path -path $global:Sharepoint.beheerini -pathtype leaf) { 
     # inlezen van object als hashwaarden. hier staan de beheer waarden
    $global:beheer = Get-Content -Path $global:Sharepoint.beheerini | ConvertFrom-Json

    # en weer verwijderen
    Remove-Item $global:Sharepoint.beheerini

    # Lokale mappen gebruiken bij programma.mode is alpha
    if ($global:programma.mode -eq "alpha") {
        $global:beheer.examenmappen = $lokalemappen
    }

    } else {
    # foutmelding weergeven en stoppen
    write-host "Het programma wordt afgesloten omdat de beheerinstellingen niet zijn gevonden op deze pc. 
Neem contact op met de sitebeheerder van de RPC SharePoint-site." -f Red
    Start-Sleep -Seconds 8
    exit;
    }

# Bepalen van de persoonlijke initialisatiebestand.
$gebruikersbestand = bepaalinitnaamgebruiker

write-host "Gebruikers instellingen inlezen."

# Inlezen oude algemene initialisatiebestand en omzetten naar gebruikersbestand. Dit kan op een gegeven moment eruit.
if (test-path -path $global:initbestand -pathtype leaf) { 
    # als nieuwe bestand al bestaat, verwijderen
    if (test-path -path $gebruikersbestand -pathtype leaf) {
         Remove-Item $gebruikersbestand
         }
    Rename-Item -Path $global:initbestand -NewName $gebruikersbestand
}

# inlezen van gebruikers instellingen
Inlezengebruikersinstellingen;


# einde intialiseren programma

# controleren op een update. 
updatevoorbereiden;


# Controles en tijdelijke taken uitvoeren
write-host "Controles en tijdelijke taken uitvoeren."

# verwijderen updater.ps1
if (test-path -path "$startmap\updater.ps1") { Remove-Item "$startmap\updater.ps1" } 

# Dit staat hier voor versies lager dan 4.5.0 om de logbestanden te hernoemen. Kan op een gegeven moment verwijderd worden.
if (test-path -path "$logmap") {
$persnr = bepaalpersoneelsnr
Get-ChildItem -Path "$logmap\log_??????????.txt" -Name | ForEach-Object {
    $file = $_
    $nieuw = $file.Insert(14,'_'+$persnr)
    $oudbestand = -join ($logmap,'\',$file)
    Rename-Item -Path $oudbestand -NewName $nieuw
}
}

# controleren of netwerkschijven bestaan en opnieuw verbinden als het nodig is. Alleen bij mode "online".
if ($global:programma.mode -eq 'online') {
    Get-SmbMapping |where -property Status -Value Unavailable -EQ | select LocalPath,RemotePath | ForEach-Object {
    $item = $_
    net use $item.LocalPath $item.RemotePath >$null 2>&1
    }
}

# Einde controles en tijdelijke taken uitvoeren


# opschonen logbestanden als dit is ingesteld. Werkt niet in windows 11
opschonenlogsbijstart;

$null = HideConsole

# deze loop is nodig om na het afmelden weer te kunnen inloggen
do {
# Hoofdvenster declareren --------------------------------------------------------------------

if ($global:programma.mode -eq 'online') {
    $koptekst = "Beheren bestanden versie " + $global:programma.versie
    } else {
    $koptekst = "Beheren bestanden versie " + $global:programma.versie + ". LET OP : Programma heeft de status " + $global:programma.mode
    }

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = New-Object System.Drawing.Point(900,550)
$Form.text                       = $koptekst
$Form.TopMost                    = $false
$Form.StartPosition              = 'CenterScreen'
$form.BackColor                  = "white"
$form.MaximizeBox                = $False
$form.Icon                       = [System.Drawing.Icon]::ExtractAssociatedIcon('beheren.ico')

$Description                     = New-Object system.Windows.Forms.Label
$Description.text                = "Welkom " + $global:Sharepoint.Gebr_naam
$Description.AutoSize            = $false
$Description.width               = 500
$Description.height              = 35
$Description.location            = New-Object System.Drawing.Point(52,15)
$Description.Font                = 'Microsoft Sans Serif,12'
# $Description.ForeColor = [System.Drawing.Color]::Blue
$Form.controls.add($Description)
$Description.add_MouseHover({
    $gebrnaam = -join ("U bent ingelogd als    ",$global:Sharepoint.gebr_inlog)
    $global:tooltip1.SetToolTip($this, $gebrnaam )
})


$uitleg1                     = New-Object system.Windows.Forms.Label
$uitleg1.text                = "Bestanden klaarzetten"
$uitleg1.AutoSize            = $false
$uitleg1.width               = 160
$uitleg1.height              = 20
$uitleg1.location            = New-Object System.Drawing.Point(56, 215)
$uitleg1.Font                = 'Microsoft Sans Serif,11'
$uitleg1.ForeColor = [System.Drawing.Color]::Blue
$Form.controls.add($uitleg1)
# $uitleg1.Add_Click({ vensterkopieren })

$uitleg2                     = New-Object system.Windows.Forms.Label
$uitleg2.text                = "Backup maken"
$uitleg2.AutoSize            = $false
$uitleg2.width               = 160
$uitleg2.height              = 20
$uitleg2.location            = New-Object System.Drawing.Point(290, 215)
$uitleg2.Font                = 'Microsoft Sans Serif,11'
$uitleg2.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg2)
# $uitleg2.Add_Click({ vensterbackup })

$uitleg3                     = New-Object system.Windows.Forms.Label
$uitleg3.text                = "Wissen"
$uitleg3.AutoSize            = $false
$uitleg3.width               = 80
$uitleg3.height              = 20
$uitleg3.location            = New-Object System.Drawing.Point(530,215)
$uitleg3.Font                = 'Microsoft Sans Serif,11'
$uitleg3.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg3)
# $uitleg3.Add_Click({ vensterwissen })

$uitleg4                     = New-Object system.Windows.Forms.Label
$uitleg4.text                = "Verplaatsen of kopiren"
$uitleg4.AutoSize            = $false
$uitleg4.width               = 170
$uitleg4.height              = 20
$uitleg4.location            = New-Object System.Drawing.Point(688,215)
$uitleg4.Font                = 'Microsoft Sans Serif,11'
$uitleg4.ForeColor = [System.Drawing.Color]::blue
$Form.controls.add($uitleg4)
# $uitleg4.Add_Click({ vensterverplaatsen })

$Button1                         = New-Object system.Windows.Forms.Button
$Button1.width                   = 160
$Button1.height                  = 160
$Button1.location                = New-Object System.Drawing.Point(52,50)
$Button1.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button1.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon bestanden klaarzetten.png")
$Button1.BackColor = [System.Drawing.Color]::green
$Button1.Add_Click({ vensterkopieren })
$Button1.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden klaarzetten voor de geselecteerde pc's in een netwerk." )
})
$Form.controls.add($Button1)

$Button2                         = New-Object system.Windows.Forms.Button
$Button2.width                   = 160
$Button2.height                  = 160
$Button2.location                = New-Object System.Drawing.Point(264,50)
$Button2.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button2.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon backup maken.png")
$Button2.BackColor = [System.Drawing.Color]::green
$Button2.Add_Click({ vensterbackup })
$Button2.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Backup maken van de bestanden in de geselecteerde pc's." )
})
$Form.controls.add($Button2)

$Button3                         = New-Object system.Windows.Forms.Button
$Button3.width                   = 160
$Button3.height                  = 160
$Button3.location                = New-Object System.Drawing.Point(476,50)
$Button3.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button3.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon wissen.png")
$Button3.BackColor = [System.Drawing.Color]::green
$Button3.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden verwijderen uit de geselecteerde pcs in het netwerk." )
})
$Button3.Add_Click({ vensterwissen })

$Form.controls.add($Button3)

$Button4                         = New-Object system.Windows.Forms.Button
$Button4.width                   = 160
$Button4.height                  = 160
$Button4.location                = New-Object System.Drawing.Point(688,50)
$Button4.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button4.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icon verplaatsen.png")
$Button4.BackColor = [System.Drawing.Color]::green
$Button4.Add_Click({ vensterverplaatsen })
$Button4.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Bestanden van n pc verplaatsen of kopieren naar een andere pc." )
})
$Form.controls.add($Button4)

$Button5                         = New-Object system.Windows.Forms.Button
$Button5.width                   = 60
$Button5.height                  = 60
$Button5.location                = New-Object System.Drawing.Point(52,270)
$Button5.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button5.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-log.png")
$Button5.Add_Click({ vensterlogbestand })
$Button5.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "De logbestanden van de uitgevoerde taken bekijken." )
})
$Form.controls.add($Button5)

$Button6                         = New-Object system.Windows.Forms.Button
$Button6.width                   = 60
$Button6.height                  = 60
$Button6.location                = New-Object System.Drawing.Point(52,360)
$Button6.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-info.png")
$Button6.Add_Click({ informatieprogramma })
$Button6.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Algemene informatie over het programma lezen." )
})
$Form.controls.add($Button6)

$Button7                         = New-Object system.Windows.Forms.Button
$Button7.width                   = 60
$Button7.height                  = 60
$Button7.location                = New-Object System.Drawing.Point(52,450)
$Button7.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button7.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-stoppen.png")
$Button7.BackColor = [System.Drawing.Color]::red
$Button7.Add_Click({ 
    $result = programmaafsluiten

    if ($result -eq 'Cancel') {
        # programma sluiten
        $form.DialogResult = [System.Windows.Forms.DialogResult]::cancel
        return
        } elseif ($result -eq 'Ok') {
        # afmelden
        $form.DialogResult = [System.Windows.Forms.DialogResult]::ok 
        } 
    })
$Button7.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Het programma afsluiten of gebruiker afmelden." )
})
$Form.controls.add($Button7)

<# handmatig updaten is niet meer mogelijk!
   Hiervoor was $Button8 gedefinieerd
#>

$Button9                         = New-Object system.Windows.Forms.Button
$Button9.width                   = 60
$Button9.height                  = 60
$Button9.location                = New-Object System.Drawing.Point(788,270)
$Button9.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button9.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-settings.png")
$Button9.Add_Click({ vensterinstellingen })
$Button9.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "De persoonlijke keuzes voor de taken van het programma wijzigen." )
})
$Form.controls.add($Button9)

$Button10                         = New-Object system.Windows.Forms.Button
$Button10.width                   = 60
$Button10.height                  = 60
$Button10.location                = New-Object System.Drawing.Point(788,360)
$Button10.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-clean.png")
$Button10.Add_Click({ vensteropschonen })
$Button10.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Oude backups verwijderen." )
})
$Form.controls.add($Button10)

# declareren venster met uitleg over programma. verschijnt als de muis over de vraagteken gaat.

$Form_uitlegprog = declareren_standaardvenster "Uitleg over het programma" 690 480
$Form_uitlegprog.ControlBox = $False


$uitlegprogtekst                     = New-Object system.Windows.Forms.Label
$uitlegprogtekst.text                = "Met dit programma kunnen bestanden op meerdere pc's in een netwerk worden beheerd.
De vier belangrijkste taken van dit programma worden met een groene icoontje weergegeven.

Met het icoontje 
    - 'Bestanden klaarzetten' worden bestanden en volledige mappen overgezet naar 
       de geselecteerde pc's.
    - 'Backup maken' wordt een backup gemaakt van de bestanden in de geselecteerde pc's.
    - 'Wissen' worden de bestanden van de geselecteerde pc's gewist.
    - 'Verplaatsen of kopiren' worden de bestanden van n pc verplaatst of gekopierd naar 
       een andere pc.

Met de drie icoontjes aan de linkerkant kunnen:
    - de logbestanden van de uitgevoerde taken bekeken worden,
    - algemene informatie over het programma worden gelezen,
    - het programma worden afgesloten of de gebruiker worden afgemeld.

Met de twee icoontjes aan de rechterkant kunnen:
    - de standaard keuzes voor de taken en overige functies van het programma worden gewijzigd,
    - oude backups worden verwijderd. 

Informatie over een taak kan verkregen worden door met de muiscursor over een object te gaan.
"
$uitlegprogtekst.AutoSize            = $false
$uitlegprogtekst.width               = 680
$uitlegprogtekst.height              = 380
$uitlegprogtekst.location            = New-Object System.Drawing.Point(10,10)
$uitlegprogtekst.Font                = 'Microsoft Sans Serif,11'
$uitlegprogtekst.ForeColor = [System.Drawing.Color]::blue
$Form_uitlegprog.Controls.Add($uitlegprogtekst)

$knopsluiten = New-object System.Windows.Forms.Button 
$knopsluiten.text= 'Sluiten'
$knopsluiten.location = "250,400" 
$knopsluiten.size = "150,30"  
$knopsluiten.BackColor = 'red'
$knopsluiten.ForeColor = 'white'
$knopsluiten.DialogResult = [System.Windows.Forms.DialogResult]::ok
$Form_uitlegprog.Controls.Add($knopsluiten)

# einde declareren venster met uitleg over programma

# declareren vraag-icoontje om extra informatiete geven over het programma
$picturequestion = new-object Windows.Forms.PictureBox
$picturequestion.Location = New-Object System.Drawing.Size(788,460)
$picturequestion.Size = New-Object System.Drawing.Size(30,60)
$picturequestion.Image = [System.Drawing.Image]::FromFile("$icoontjesmap\icoon-hulp.png")
$picturequestion.add_click( { $Form_uitlegprog.showdialog() } )
$picturequestion.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Klik hier voor uitleg over het programma." )
})
$Form.controls.add($picturequestion)

#GIF afbeelding toevoegen
$gifBox = New-Object Windows.Forms.picturebox
# $gifLink= (Get-Item -Path '.\filetransfer.gif')
# $img = [System.Drawing.Image]::fromfile($gifLink)
$gifBox.AutoSize = $true
$gifBox.Image = [System.Drawing.Image]::FromFile("$icoontjesmap\filetransfer.gif")
# $gifBox.location                = New-Object System.Drawing.Point(140,250)
$gifBox.location                = New-Object System.Drawing.Point(130,226)
$gifBox.add_click( { Venstermetgrap } )
$gifBox.add_MouseHover({
    $global:tooltip1.SetToolTip($this, "Klik hier voor een leuke grap." )
})

$Form.Controls.Add($gifbox)

# Einde hoofdvenster declareren

# Als het programma in testfase is, dan venster tonen met melding
$form.add_Shown({ 
    $mode=$global:programma.mode
    if ($global:programma.mode -ne 'online') {
        $null = vraagvenster "Programma is nog in testfase" "
        LET OP : Programma is nog in testfase $mode.
        Gebruik het programma nu alleen voor testdoeleinden." "Ok"
    }
 } )

# Form wordt getoond. dit is de hoofdvenster

$hoofdproces = $Form.ShowDialog()

if ($hoofdproces -eq [System.Windows.Forms.DialogResult]::cancel) {
    $Form.dispose()
    $doorgaan = $false
} else {
    $doorgaan = $true
}


if ($hoofdproces -eq [System.Windows.Forms.DialogResult]::ok) {

# hoofdmenu sluiten
$Form.dispose()

# verbinding met Sharepoint verbreken
Disconnect-PnPOnline

# inloggen via mfa naar Sharepoint
VerbindSharepoint;

# afsluiten als je niet bent ingelogd.
$doorgaan = $global:Sharepoint.ingelogd

if ($doorgaan) {
    # inlezen van gebruikers instellingen
    Inlezengebruikersinstellingen;
}

}

} while ($doorgaan) 

# einde script.