<# 
Beherenbestanden.ps1

Programma om bestanden in studentmappen te beheren, dus bestanden klaarzetten, backuppen, verplaatsen of wissen.

Zie voor versienummer onder "Declareren variabelen".

Versienummer wordt volgens Semantic Versioning uitgevoerd (zie https://Semver.org)

Dit programma is beschermt met auteursplicht door middel van de GNU GPL (https://www.gnu.org/licenses)

Lees ook de readme.txt op https://neveshuis.nl/beherenbestanden/readme.txt
#>

# toevoegen .NET framework klassen ---------------------------------------------------------
Add-Type -AssemblyName PresentationFramework
Add-Type -AssemblyName System.Drawing
Add-Type -AssemblyName System.Windows.Forms

# VisualStyles aan zetten ------------------------------------------------------------------
[System.Windows.Forms.Application]::EnableVisualStyles()

<# Declareren variabelen ---------------------------------------------------------------------
   Bij functie standaardinstellingen onder sectie "Functions" staan de variabelen die door gebruikers
   gewijzigd kunnen worden #>

# versie van dit programma wordt weergegeven in de titel
[string]$global:Versie = "4.2.2"

<# Een extra label wordt weergegeven bij info over dit programma. 
   Een extra label kan een pre-release zijn of een build.
   Een pre-release wordt aangegeven met alpha.DATE (of beta.DATE) en een build met BUILDNUMBER.DATE 
   De BUILDNUMBER geeft aan hoe vaak het programma uitgebracht is. #>
[string]$extralabel = "alpha.220926"

# startmap met digitale bestanden
$digitalebestanden="B:\HR_TM_T2000\examendocumenten\digitale bijlagen"
# $digitalebestanden="C:\Users\$env:username\testwerking\digitale bijlagen"

# locatie van home-map van de studenten
$homemapstudenten="Y:\RPC"
# $homemapstudenten="C:\Users\$env:username\testwerking\doel"

# backupmap voor bewaren van kandidaatmappen
$backupmap="B:\HR_TM_T2000\backup kandidaten"
# $backupmap="C:\Users\$env:username\testwerking\backup kandidaten"

# startmap van het programma
$startmap=Split-Path -Parent $PSCommandPath

# map met png icoontjes
$icoontjesmap = -join ("$startmap","\","png")

# map voor logbestanden
$logmap = -join ("$startmap","\","log")

<# object met alle variabelen die in initialisatiebestand bewaard worden. Dit zijn de instellingen die gewijzigd kunnen worden.
   Zie ook functie standaardinstellingen onder sectie "Functions" #>
$Global:init=@{}

# locaties definiren
$PAL = @{
    naam = 'Prins Alexanderlaan'
    eerstenr = 1
    laatstenr= 50
}

$SHW = @{
    naam = 'Schiedamswweg'
    eerstenr = 131
    laatstenr= 180
}

$JLS = @{
    naam = 'Jan Ligthartstraat'
    eerstenr = 201
    laatstenr= 240
}

$global:locaties = @{
    PAL = $PAL
    SHW = $SHW
    JLS = $JLS
    }

# bestand met variabelen die gewijzigd kunnen worden en of extern bewaard moeten worden
$global:initbestand = "initialisatie.ini"
# volledige pad toevoegen aan variabele
$global:initbestand = -join ("$startmap","\","$global:initbestand")

# website met updates van programma
$updatewebsite = "https://neveshuis.nl/beherenbestanden"

# bestand met info over update. staat op de website
$global:updateinfo = "updateinfo.ini"

# script die het programma update. deze is in de root aanwezig.
$updater = "updater.ps1"

# de 2 bestanden met info voor venster informatieprogramma
$readmebestand="readme.txt"
$changelogbestand="changelog.txt"

# nodig voor werken met hashtabels. zie functies uitvoerentaken en overzichttaken
$uitvoeren = [hashtable]::Synchronized(@{})

# Einde declareren variabelen

# opstart venster declareren en weergeven ----------------------------------------------------------------------
$Form_opstart                            = New-Object system.Windows.Forms.Form
$Form_opstart.ClientSize                 = New-Object System.Drawing.Point(450,180)
$Form_opstart.text                       = "Beheren bestanden versie " + "$global:Versie"
$Form_opstart.TopMost                    = $false
$Form_opstart.StartPosition              = 'CenterScreen'

$opstarttekst                     = New-Object system.Windows.Forms.Label
$opstarttekst.text                = "Programma wordt opgestart."
$opstarttekst.AutoSize            = $false
$opstarttekst.width               = 300
$opstarttekst.height              = 30
$opstarttekst.location            = New-Object System.Drawing.Point(20,15)
$opstarttekst.Font                = 'Microsoft Sans Serif,12'
$opstarttekst.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstarttekst)

$opstartinfo                     = New-Object system.Windows.Forms.Label
$opstartinfo.text                = ""
$opstartinfo.AutoSize            = $false
$opstartinfo.width               = 400
$opstartinfo.height              = 100
$opstartinfo.location            = New-Object System.Drawing.Point(20,50)
$opstartinfo.Font                = 'Microsoft Sans Serif,12'
$opstartinfo.ForeColor = [System.Drawing.Color]::Blue
$Form_opstart.Controls.Add($opstartinfo)

$Form_opstart.Show()


# Hoofdvenster declareren --------------------------------------------------------------------

$Form                            = New-Object system.Windows.Forms.Form
$Form.ClientSize                 = New-Object System.Drawing.Point(900,550)
$Form.text                       = "Beheren bestanden versie " + "$global:Versie"
$Form.TopMost                    = $false
$Form.StartPosition              = 'CenterScreen'

$Description                     = New-Object system.Windows.Forms.Label
$Description.text                = "Programma voor het beheren van digitale bestanden. 
Maak een keuze door op een icoontje of tekst te klikken."
$Description.AutoSize            = $false
$Description.width               = 520
$Description.height              = 42
$Description.location            = New-Object System.Drawing.Point(20,15)
$Description.Font                = 'Microsoft Sans Serif,12'
$Description.ForeColor = [System.Drawing.Color]::Blue

$uitleg1                     = New-Object system.Windows.Forms.Label
$uitleg1.text                = "Bestanden klaarzetten in de studentmappen."
$uitleg1.AutoSize            = $false
$uitleg1.width               = 350
$uitleg1.height              = 40
$uitleg1.location            = New-Object System.Drawing.Point(90,80)
$uitleg1.Font                = 'Microsoft Sans Serif,11'
$uitleg1.ForeColor = [System.Drawing.Color]::Green
$uitleg1.add_MouseEnter( {$uitleg1.ForeColor = [System.Drawing.Color]::blue} )
$uitleg1.add_MouseLeave( {$uitleg1.ForeColor = [System.Drawing.Color]::green } )
$uitleg1.Add_Click({ vensterkopieren })

$uitleg2                     = New-Object system.Windows.Forms.Label
$uitleg2.text                = "Backup maken van de studentmappen."
$uitleg2.AutoSize            = $false
$uitleg2.width               = 350
$uitleg2.height              = 40
$uitleg2.location            = New-Object System.Drawing.Point(90,140)
$uitleg2.Font                = 'Microsoft Sans Serif,11'
$uitleg2.add_MouseEnter( {$uitleg2.ForeColor = [System.Drawing.Color]::blue} )
$uitleg2.add_MouseLeave( {$uitleg2.ForeColor = [System.Drawing.Color]::green } )
$uitleg2.ForeColor = [System.Drawing.Color]::Green
$uitleg2.Add_Click({ vensterbackup })

$uitleg3                     = New-Object system.Windows.Forms.Label
$uitleg3.text                = "Wissen van bestanden uit de studentmappen."
$uitleg3.AutoSize            = $false
$uitleg3.width               = 350
$uitleg3.height              = 40
$uitleg3.location            = New-Object System.Drawing.Point(90,200)
$uitleg3.Font                = 'Microsoft Sans Serif,11'
$uitleg3.add_MouseEnter( {$uitleg3.ForeColor = [System.Drawing.Color]::blue} )
$uitleg3.add_MouseLeave( {$uitleg3.ForeColor = [System.Drawing.Color]::green } )
$uitleg3.ForeColor = [System.Drawing.Color]::Green
$uitleg3.Add_Click({ vensterwissen })

$uitleg4                     = New-Object system.Windows.Forms.Label
$uitleg4.text                = "Verplaatsen of kopiren van bestanden tussen studentmappen."
$uitleg4.AutoSize            = $false
$uitleg4.width               = 350
$uitleg4.height              = 40
$uitleg4.location            = New-Object System.Drawing.Point(90,260)
$uitleg4.Font                = 'Microsoft Sans Serif,11'
$uitleg4.ForeColor = [System.Drawing.Color]::Green
$uitleg4.add_MouseEnter( {$uitleg4.ForeColor = [System.Drawing.Color]::blue} )
$uitleg4.add_MouseLeave( {$uitleg4.ForeColor = [System.Drawing.Color]::green } )
$uitleg4.Add_Click({ vensterverplaatsen })


$uitleg6                     = New-Object system.Windows.Forms.Label
$uitleg6.text                = "Programma sluiten."
$uitleg6.AutoSize            = $false
$uitleg6.width               = 350
$uitleg6.height              = 40
$uitleg6.location            = New-Object System.Drawing.Point(90,380)
$uitleg6.Font                = 'Microsoft Sans Serif,11'
$uitleg6.ForeColor = [System.Drawing.Color]::Red
$uitleg6.add_MouseEnter( {$uitleg6.ForeColor = [System.Drawing.Color]::blue} )
$uitleg6.add_MouseLeave( {$uitleg6.ForeColor = [System.Drawing.Color]::Red} )
$uitleg6.Add_Click({ programmaafsluiten })

$uitleg7                     = New-Object system.Windows.Forms.Label
$uitleg7.text                = "Logbestanden bekijken."
$uitleg7.AutoSize            = $false
$uitleg7.width               = 350
$uitleg7.height              = 40
$uitleg7.location            = New-Object System.Drawing.Point(550,80)
$uitleg7.Font                = 'Microsoft Sans Serif,11'
$uitleg7.ForeColor = [System.Drawing.Color]::Green
$uitleg7.add_MouseEnter( {$uitleg7.ForeColor = [System.Drawing.Color]::blue} )
$uitleg7.add_MouseLeave( {$uitleg7.ForeColor = [System.Drawing.Color]::green} )
$uitleg7.Add_Click({ vensterlogbestand })

$uitleg8                     = New-Object system.Windows.Forms.Label
$uitleg8.text                = "Programma updaten."
$uitleg8.AutoSize            = $false
$uitleg8.width               = 350
$uitleg8.height              = 40
$uitleg8.location            = New-Object System.Drawing.Point(550,140)
$uitleg8.Font                = 'Microsoft Sans Serif,11'
$uitleg8.ForeColor = [System.Drawing.Color]::Green
$uitleg8.add_MouseEnter( {$uitleg8.ForeColor = [System.Drawing.Color]::blue} )
$uitleg8.add_MouseLeave( {$uitleg8.ForeColor = [System.Drawing.Color]::green} )
$uitleg8.Add_Click({ updatevoorbereiden ("keuzemenu") })

$uitleg9                     = New-Object system.Windows.Forms.Label
$uitleg9.text                = "Instellingen wijzigen."
$uitleg9.AutoSize            = $false
$uitleg9.width               = 350
$uitleg9.height              = 40
$uitleg9.location            = New-Object System.Drawing.Point(550,200)
$uitleg9.Font                = 'Microsoft Sans Serif,11'
$uitleg9.ForeColor = [System.Drawing.Color]::Green
$uitleg9.add_MouseEnter( {$uitleg9.ForeColor = [System.Drawing.Color]::blue} )
$uitleg9.add_MouseLeave( {$uitleg9.ForeColor = [System.Drawing.Color]::green} )
$uitleg9.Add_Click({ vensterinstellingen })

$uitleg10                     = New-Object system.Windows.Forms.Label
$uitleg10.text                = "Opschonen logbestanden en backups."
$uitleg10.AutoSize            = $false
$uitleg10.width               = 350
$uitleg10.height              = 40
$uitleg10.location            = New-Object System.Drawing.Point(550,260)
$uitleg10.Font                = 'Microsoft Sans Serif,11'
$uitleg10.ForeColor = [System.Drawing.Color]::Green
$uitleg10.add_MouseEnter( {$uitleg10.ForeColor = [System.Drawing.Color]::blue} )
$uitleg10.add_MouseLeave( {$uitleg10.ForeColor = [System.Drawing.Color]::green} )
$uitleg10.Add_Click({ vensteropschonen })

$uitleg11                     = New-Object system.Windows.Forms.Label
$uitleg11.text                = "Informatie over het programma."
$uitleg11.AutoSize            = $false
$uitleg11.width               = 350
$uitleg11.height              = 40
$uitleg11.location            = New-Object System.Drawing.Point(550,380)
$uitleg11.Font                = 'Microsoft Sans Serif,11'
$uitleg11.ForeColor = [System.Drawing.Color]::Green
$uitleg11.add_MouseEnter( {$uitleg11.ForeColor = [System.Drawing.Color]::blue} )
$uitleg11.add_MouseLeave( {$uitleg11.ForeColor = [System.Drawing.Color]::green} )
$uitleg11.Add_Click({ informatieprogramma })

$Button1                         = New-Object system.Windows.Forms.Button
$Button1.width                   = 60
$Button1.height                  = 60
$Button1.location                = New-Object System.Drawing.Point(20,60)
$Button1.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button1.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-copy.png")
$Button1.Add_Click({ vensterkopieren })

$Button2                         = New-Object system.Windows.Forms.Button
$Button2.width                   = 60
$Button2.height                  = 60
$Button2.location                = New-Object System.Drawing.Point(20,120)
$Button2.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button2.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-backup.png")
$Button2.Add_Click({ vensterbackup })

$Button3                         = New-Object system.Windows.Forms.Button
$Button3.width                   = 60
$Button3.height                  = 60
$Button3.location                = New-Object System.Drawing.Point(20,180)
$Button3.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button3.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-delete.png")
$Button3.Add_Click({ vensterwissen })

$Button4                         = New-Object system.Windows.Forms.Button
$Button4.width                   = 60
$Button4.height                  = 60
$Button4.location                = New-Object System.Drawing.Point(20,240)
$Button4.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button4.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-verplaatsen.png")
$Button4.Add_Click({ vensterverplaatsen })


$Button6                         = New-Object system.Windows.Forms.Button
$Button6.width                   = 60
$Button6.height                  = 60
$Button6.location                = New-Object System.Drawing.Point(20,360)
$Button6.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button6.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-stoppen.png")
$Button6.Add_Click({ programmaafsluiten })

$Button7                         = New-Object system.Windows.Forms.Button
$Button7.width                   = 60
$Button7.height                  = 60
$Button7.location                = New-Object System.Drawing.Point(480,60)
$Button7.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button7.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-log.png")
$Button7.Add_Click({ vensterlogbestand })

$Button8                         = New-Object system.Windows.Forms.Button
$Button8.width                   = 60
$Button8.height                  = 60
$Button8.location                = New-Object System.Drawing.Point(480,120)
$Button8.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button8.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-update.png")
$Button8.Add_Click({ updatevoorbereiden ("keuzemenu") })

$Button9                         = New-Object system.Windows.Forms.Button
$Button9.width                   = 60
$Button9.height                  = 60
$Button9.location                = New-Object System.Drawing.Point(480,180)
$Button9.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button9.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-settings.png")
$Button9.Add_Click({ vensterinstellingen })

$Button10                         = New-Object system.Windows.Forms.Button
$Button10.width                   = 60
$Button10.height                  = 60
$Button10.location                = New-Object System.Drawing.Point(480,240)
$Button10.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button10.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-clean.png")
$Button10.Add_Click({ vensteropschonen })

$Button11                         = New-Object system.Windows.Forms.Button
$Button11.width                   = 60
$Button11.height                  = 60
$Button11.location                = New-Object System.Drawing.Point(480,360)
$Button11.Font                    = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$Button11.Image=[System.Drawing.Image]::FromFile("$icoontjesmap\icoon-hulp.png")
$Button11.Add_Click({ informatieprogramma })


$Form.controls.AddRange(@($Description,$Button1,$Button2, $Button3, $Button4, $Button6, $Button7, $Button8, $Button9, $Button10, $Button11, $uitleg1, $uitleg2, $uitleg3, $uitleg4, 
$uitleg6, $uitleg7, $uitleg8, $uitleg9, $uitleg10, $uitleg11 ))

# Einde hoofdvenster declareren


# functions ---------------------------------------------------------------------------------
# hieronder de kleine functies die door andere functies gebruikt worden ---------------------

function venster_werkinuitvoering ($koptekst,$infotekst) {
# deze functie wordt nog nergens gebruikt!

$global:Form_inuitvoering                            = New-Object system.Windows.Forms.Form
$global:Form_inuitvoering.ClientSize                 = New-Object System.Drawing.Point(450,180)
$global:Form_inuitvoering.text                       = "Werk in uitvoering"
$global:Form_inuitvoering.TopMost                    = $false
$global:Form_inuitvoering.StartPosition              = 'CenterScreen'

if (!($koptekst -eq $null)) {
$inuitvoeringtekst                     = New-Object system.Windows.Forms.Label
$inuitvoeringtekst.text                = "koptekst"
$inuitvoeringtekst.AutoSize            = $false
$inuitvoeringtekst.width               = 300
$inuitvoeringtekst.height              = 30
$inuitvoeringtekst.location            = New-Object System.Drawing.Point(20,15)
$inuitvoeringtekst.Font                = 'Microsoft Sans Serif,12'
$inuitvoeringtekst.ForeColor = [System.Drawing.Color]::Blue
$global:Form_inuitvoering.Controls.Add($inuitvoeringtekst)
}

if (!($infotekst -eq $null)) {
$inuitvoeringinfo                     = New-Object system.Windows.Forms.Label
$inuitvoeringinfo.text                = $infotekst
$inuitvoeringinfo.AutoSize            = $false
$inuitvoeringinfo.width               = 400
$inuitvoeringinfo.height              = 100
$inuitvoeringinfo.location            = New-Object System.Drawing.Point(20,50)
$inuitvoeringinfo.Font                = 'Microsoft Sans Serif,12'
$inuitvoeringinfo.ForeColor = [System.Drawing.Color]::Blue
$global:Form_inuitvoering.Controls.Add($inuitvoeringinfo)
}

$global:Form_inuitvoering.Show()
}

function sluiten_werkinuitvoering {
# deze functie wordt nog nergens gebruikt!

$global:Form_inuitvoering.Dispose()
}

function bepaallognaam ($invoer)

{
<# de lognaam wordt bepaald adhv de invoer. dit is een datum in de format yyyy-mm-dd. Zie ook function Bepaaldatum.
   functie "bepaaldatumuitlognaam" doet het omgekeerde, dus een verandering hier moet ook in deze functie worden aangepast.
#>
$lognaam = -join ("$logmap","\log_","$invoer",".txt")

return $lognaam
}

function bepaaldatumuitlognaam ($invoer)
{
<# Uit de invoer wordt de datum bepaald. De format hiervoor staat in functie "bepaallognaam".
  Een wijziging in deze functie moet hier ook worden toegepast.
#>
$datumintekst = $invoer.substring(4, 10)
return $datumintekst
}

function bepaalversiemap ($invoer)
{
# bepaalt de map waar de versie in staat mbv de gegeven versie (invoer)

$major = $invoer.split('.')[0]
$minor = $invoer.split('.')[1]
$revision = $invoer.split('.')[2]

$versiemap = -join ("$updatewebsite","/updates/","$major",".","$minor" )
return $versiemap
}

function bepaaldatum {
# datum bepalen
$datumvandaag = get-date -Format "yyyy-MM-dd"
return $datumvandaag
}

function standaardinstellingen 
{
# hier worden de standaard instellingen gedeclareerd die gebruikers kunnen wijzigen


$algemeen=@{
    locatiekeuze = 'PAL'
    autoupdate = 'ja'
    wissennabackup = 'ja'
    updatenotificatie = 'ja'
    maplegenvoorverplaatsen = 'ja'
}

$opschonen=@{
    dagenbewarenbackup = 730
    dagenbewarenlogs = 365
    opschonenlogs = 'ja'
}

$Std_inst=@{
    algemeen=$algemeen
    opschonen=$opschonen
}

return $Std_inst
}

function Get-IniContent ($filePath)
{
# Leest een bestand met instellingen en geeft deze terug als een array
    $ini = @{}
    switch -regex -file $FilePath
    {
        ^\[(.+)\] # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        ^(;.*)$ # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = Comment + $CommentCount
            $ini[$section][$name] = $value
        }
        (.+?)\s*=(.*) # Key
        {
            $name,$value = $matches[1..2]
            $ini[$section][$name] = $value
        }
    }
    return $ini
}


function declareren_rpcnrs {

# Venster voor weergeven rpcnummer declareren. Wordt bij meerdere functies gebruikt.

$listbox_temp = New-Object System.Windows.Forms.Listbox
$listbox_temp.Location = New-Object System.Drawing.Point(10,40)
$listbox_temp.Size = New-Object System.Drawing.Size(150,20)
$listbox_temp.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listbox_temp.SelectionMode = 'MultiExtended'
$listbox_temp.Height = 500

return $listbox_temp
}

function lijstrpcnrsaanmaken ($keuzelocatie, $listbox_temp) {
# een lijst met rpc-nummers wordt gemaakt adhv gekozen locatie

# lijst wordt leeggemaakt
$listbox_temp.Items.Clear()

# waarden uit array halen die nodig zijn om lijst te maken met rpc-nummers
[int]$keuzeeerstenr=$global:locaties["$keuzelocatie"]["eerstenr"]
[int]$keuzelaatstenr=$global:locaties["$keuzelocatie"]["laatstenr"]

#listbox items aanmaken
For ($i=$keuzeeerstenr; $i -le $keuzelaatstenr; $i++) {

    if ($i -lt 10) {$rpcnr="RPC-00"+"$i"}
    elseif ($i -lt 100) {$rpcnr="RPC-0"+"$i"}
    else {$rpcnr="RPC-"+"$i"}
    [void] $listbox_temp.Items.Add($rpcnr)
}

return $listbox_temp
}

function vraagvenster ($titel, $vraag, $knopok, $knopannuleren)  {

# venster declareren
$formvraag                            = New-Object system.Windows.Forms.Form
$formvraag.ClientSize                 = New-Object System.Drawing.Point(600,180)
$formvraag.text                       = $titel
$formvraag.TopMost                    = $false
$formvraag.StartPosition              = 'CenterScreen'

$vraaglabel                     = New-Object system.Windows.Forms.Label
$vraaglabel.text                = $vraag
$vraaglabel.AutoSize            = $false
$vraaglabel.width               = 550
$vraaglabel.height              = 110
$vraaglabel.location            = New-Object System.Drawing.Point(20,15)
$vraaglabel.Font                = 'Microsoft Sans Serif,11'
$vraaglabel.ForeColor = [System.Drawing.Color]::Blue
$formvraag.Controls.Add($vraaglabel)

# knop ok wordt altijd weergegeven. knop annuleren alleen als een 2e knop-naam gegeven is.
$vraagok = New-object System.Windows.Forms.Button 
if (!($knopok -eq $null) ) { 
    $vraagok.text= $knopok
} else {
    $vraagok.text= "Ok"
}
$vraagok.location = "50,130" 
$vraagok.size = "150,30"  
if ($vraagok.text -eq "Ok") { $vraagok.BackColor = 'blue' }
   else { $vraagok.BackColor = 'green' }
$vraagok.ForeColor = 'white'
$vraagok.DialogResult = [System.Windows.Forms.DialogResult]::ok
$formvraag.Controls.Add($vraagok)


if (!($knopannuleren -eq $null) ) { 
$vraagescape = New-object System.Windows.Forms.Button 
$vraagescape.text= $knopannuleren
$vraagescape.location = "250,130" 
$vraagescape.size = "150,30"  
$vraagescape.BackColor = 'red'
$vraagescape.ForeColor = 'white'
$vraagescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$formvraag.Controls.Add($vraagescape)
}

$formvraag.controls.AddRange(@($vraaglabel, $vraagok, $vraagescape ))

$result = $formvraag.ShowDialog()
    
$formvraag.close();

return $result
}

# hieronder de hoofdfuncties ----------------------------------------------------------------



function scriptRun {

function backup_mapcontrole ([string]$rpcnummer)

{
<# Deze procedure wordt gebruikt bij functie uitvoerentaken.
   Bij de taak backup van functie uitvoerentaken wordt gecontroleerd of al een backup is gemaakt.
   als dit zo is wordt bij deze functie een keuze gegeven wat ermee te doen.
#>

# antwoord als op kruis wordt geklikt
$antwoordvraag = "overslaan"

$Form4                            = New-Object system.Windows.Forms.Form
$Form4.ClientSize                 = New-Object System.Drawing.Point(600,250)
$Form4.text                       = "Backup van studentmap is al gemaakt."
$Form4.TopMost                    = $false
$Form4.StartPosition              = 'CenterScreen'

$uitleg_mapcontrole               = New-Object system.Windows.Forms.Label
$uitleg_mapcontrole.AutoSize      = $false
$uitleg_mapcontrole.Text          = "Een backup van studentmap $rpcnummer is al gemaakt.
Geef aan wat u hiermee wilt doen."
$uitleg_mapcontrole.width         = 500
$uitleg_mapcontrole.height        = 40
$uitleg_mapcontrole.location      = New-Object System.Drawing.Point(20,10)
$uitleg_mapcontrole.Font          = 'Microsoft Sans Serif,11'
$uitleg_mapcontrole.ForeColor     = 'blue'

$keuze1_mapcontrole = New-Object System.Windows.Forms.Button
$keuze1_mapcontrole.Location = New-Object System.Drawing.Size(20, 60)
$keuze1_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze1_mapcontrole.Text = "Verwijderen"
$keuze1_mapcontrole.height = 40
$keuze1_mapcontrole.BackColor = 'green'
$keuze1_mapcontrole.ForeColor = 'white'
$keuze1_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Yes

$keuze2_mapcontrole = New-Object System.Windows.Forms.Button
$keuze2_mapcontrole.Location = New-Object System.Drawing.Size(20, 120)
$keuze2_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze2_mapcontrole.Text = "Behouden"
$keuze2_mapcontrole.height = 40
$keuze2_mapcontrole.BackColor = 'green'
$keuze2_mapcontrole.ForeColor = 'white'
$keuze2_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Ignore


$uitleg1_vraag               = New-Object system.Windows.Forms.Label
$uitleg1_vraag.AutoSize      = $false
$uitleg1_vraag.Text          = "Bestaande backup wordt verwijderd en een nieuwe backup wordt gemaakt."
$uitleg1_vraag.width         = 440
$uitleg1_vraag.height        = 40
$uitleg1_vraag.location      = New-Object System.Drawing.Point(160,60)
$uitleg1_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg1_vraag.ForeColor     = 'blue'

$uitleg2_vraag               = New-Object system.Windows.Forms.Label
$uitleg2_vraag.AutoSize      = $false
$uitleg2_vraag.Text          = "Bestaande backup wordt behouden. Er wordt geen nieuwe backup gemaakt."
$uitleg2_vraag.width         = 440
$uitleg2_vraag.height        = 40
$uitleg2_vraag.location      = New-Object System.Drawing.Point(160,120)
$uitleg2_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg2_vraag.ForeColor     = 'blue'


$optieherhalen = New-Object System.Windows.Forms.Checkbox 
$optieherhalen.Location = New-Object System.Drawing.Point(20,170)
$optieherhalen.Size = New-Object System.Drawing.Size(500,30)
$optieherhalen.Text = "Deze keuze herhalen voor alle studentmappen waarvan een backup is gemaakt."
$optieherhalen.checked = $false
$optieherhalen.Font = 'Microsoft Sans Serif,11'
$optieherhalen.ForeColor     = 'green'
$optieherhalen.height = 50

$form4.controls.AddRange(@($uitleg_mapcontrole, $uitleg1_vraag, $uitleg2_vraag, $keuze1_mapcontrole, $keuze2_mapcontrole, $optieherhalen ))
$form4.Topmost = $false

$result = $form4.ShowDialog()

if ($result -eq [system.windows.forms.dialogResult]::Yes) {
    $antwoordvraag = "wissen"
    } else {
    $antwoordvraag = "overslaan"
    }

# variabelen teruggeven
return $antwoordvraag, $optieherhalen.checked
}

function kopieren_mapcontrole ([string]$rpcnummer)

{
<# Deze procedure wordt gebruikt bij functie uitvoerentaken.
   Bij de taak overzetten van functie uitvoerentaken wordt gecontroleerd of een map inhoud heeft.
   als dit zo is wordt bij deze functie een keuze gegeven wat ermee te doen.
#>

# antwoord als op kruis wordt geklikt
$antwoordvraag = "overslaan"

$Form4                            = New-Object system.Windows.Forms.Form
$Form4.ClientSize                 = New-Object System.Drawing.Point(600,270)
$Form4.text                       = "Bestanden aanwezig in een studentmap."
$Form4.TopMost                    = $false
$Form4.StartPosition              = 'CenterScreen'

$uitleg_mapcontrole               = New-Object system.Windows.Forms.Label
$uitleg_mapcontrole.AutoSize      = $false
$uitleg_mapcontrole.Text          = "Er zijn bestanden gevonden in studentmap $rpcnummer.
Geef aan wat u hiermee wilt doen."
$uitleg_mapcontrole.width         = 500
$uitleg_mapcontrole.height        = 40
$uitleg_mapcontrole.location      = New-Object System.Drawing.Point(20,10)
$uitleg_mapcontrole.Font          = 'Microsoft Sans Serif,11'
$uitleg_mapcontrole.ForeColor     = 'blue'

$keuze1_mapcontrole = New-Object System.Windows.Forms.Button
$keuze1_mapcontrole.Location = New-Object System.Drawing.Size(20, 60)
$keuze1_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze1_mapcontrole.Text = "Behouden"
$keuze1_mapcontrole.height = 40
$keuze1_mapcontrole.BackColor = 'green'
$keuze1_mapcontrole.ForeColor = 'white'
$keuze1_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::No

$keuze2_mapcontrole = New-Object System.Windows.Forms.Button
$keuze2_mapcontrole.Location = New-Object System.Drawing.Size(20, 120)
$keuze2_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze2_mapcontrole.Text = "Verwijderen"
$keuze2_mapcontrole.height = 40
$keuze2_mapcontrole.BackColor = 'green'
$keuze2_mapcontrole.ForeColor = 'white'
$keuze2_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Yes

$keuze3_mapcontrole = New-Object System.Windows.Forms.Button
$keuze3_mapcontrole.Location = New-Object System.Drawing.Size(20, 180)
$keuze3_mapcontrole.Size = New-Object System.Drawing.Size(120, 50)
$keuze3_mapcontrole.Text = "Overslaan"
$keuze3_mapcontrole.height = 40
$keuze3_mapcontrole.BackColor = 'green'
$keuze3_mapcontrole.ForeColor = 'white'
$keuze3_mapcontrole.DialogResult = [System.Windows.Forms.DialogResult]::Ignore

$uitleg1_vraag               = New-Object system.Windows.Forms.Label
$uitleg1_vraag.AutoSize      = $false
$uitleg1_vraag.Text          = "Deze bestanden worden behouden en nieuwe bestanden worden overgezet."
$uitleg1_vraag.width         = 440
$uitleg1_vraag.height        = 40
$uitleg1_vraag.location      = New-Object System.Drawing.Point(160,60)
$uitleg1_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg1_vraag.ForeColor     = 'blue'

$uitleg2_vraag               = New-Object system.Windows.Forms.Label
$uitleg2_vraag.AutoSize      = $false
$uitleg2_vraag.Text          = "Deze bestanden worden verwijderd en nieuwe bestanden worden toegevoegd."
$uitleg2_vraag.width         = 440
$uitleg2_vraag.height        = 40
$uitleg2_vraag.location      = New-Object System.Drawing.Point(160,120)
$uitleg2_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg2_vraag.ForeColor     = 'blue'

$uitleg3_vraag               = New-Object system.Windows.Forms.Label
$uitleg3_vraag.AutoSize      = $false
$uitleg3_vraag.Text          = "Deze studentmap overslaan. Er worden geen bestanden verwijderd of nieuwe bestanden overgezet."
$uitleg3_vraag.width         = 440
$uitleg3_vraag.height        = 40
$uitleg3_vraag.location      = New-Object System.Drawing.Point(160,180)
$uitleg3_vraag.Font          = 'Microsoft Sans Serif,11'
$uitleg3_vraag.ForeColor     = 'blue'

$optieherhalen = New-Object System.Windows.Forms.Checkbox 
$optieherhalen.Location = New-Object System.Drawing.Point(60,230)
$optieherhalen.Size = New-Object System.Drawing.Size(500,30)
$optieherhalen.Text = "Deze keuze herhalen voor alle mappen die bestanden hebben."
$optieherhalen.checked = $false
$optieherhalen.ForeColor     = 'green'
$optieherhalen.Font = 'Microsoft Sans Serif,11'

$form4.controls.AddRange(@($uitleg_mapcontrole, $uitleg1_vraag, $uitleg2_vraag, $uitleg3_vraag, $keuze1_mapcontrole, $keuze2_mapcontrole, $keuze3_mapcontrole, $optieherhalen ))
$form4.Topmost = $false

$result = $form4.ShowDialog()

if ($result -eq [system.windows.forms.dialogResult]::No) { 
    $antwoordvraag = "toevoegen"
    } elseif ($result -eq [system.windows.forms.dialogResult]::Yes) {
    $antwoordvraag = "wissen"
    } else {
    $antwoordvraag = "overslaan"
    }

# variabelen teruggeven
return $antwoordvraag, $optieherhalen.checked
}

# nodig voor afhandelen foutmeldingen
$uitvoeren.foutmelding = $false

# nodig om in logbestand te schrijven
$logbestand = $uitvoeren.logbestand

# datum van vandaag. nodig bij taak backup.
$datumvandaag = get-date -Format "yyyy-MM-dd"

# hier wordt de taak uitgevoerd.
switch ($uitvoeren.taak) {

    "backup"   { 

    # variabele keuzeherhalen kan "true" worden bij functie kopieren_mapcontrole
    # standaard wordt de keuze niet herhaald
    $keuzeherhalen = $false

    #kopiren bestanden naar studentmappen
    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()
        
        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "
        $infomelding_log = "[ $rpcitem - INFO ] : "

        # bepalen bronmap. dit is de homemap van de kandidaten
        $bronmap = -join ($uitvoeren.homemap,'\',$rpcitem)

        # bepalen doelmap. dit is de map waar de backup in komt.
        $doelmap = -join ($uitvoeren.doelmap,'\',$datumvandaag,'\',$rpcitem)

        <# variabele nodig voor backuptaak
           standaard wordt kopieren uitgevoerd
        #>
        $uitvoerenwissen = $false
        $uitvoerenbackup = $true
        
        # controleren of backup voor deze rpcnr al gemaakt is, door map op inhoud te controleren
        if (test-path "$doelmap\*" ) {

            "$infomelding_log" + "Er is al een backup gemaakt van deze studentmap. " | out-file "$logbestand" -Append

            # controleren of er is gekozen om keuze te herhalen
            if (!($keuzeherhalen)) {

            # vragen wat te doen met bestanden in map
            $antwoordvraag, $keuzeherhalen = backup_mapcontrole "$rpcitem"
            if ($antwoordvraag -eq "wissen") { 
                $uitvoerenwissen = $true 
                "$infomelding_log" + "U heeft gekozen de oude backup te verwijderen. " | out-file "$logbestand" -Append
                }
            if ($antwoordvraag -eq "overslaan") { 
                $uitvoerenbackup = $false 
                "$infomelding_log" + "U heeft gekozen de oude backup te behouden. " | out-file "$logbestand" -Append
                }
            if ($keuzeherhalen) {
                # onthouden van keuzes
                $onthoudkeuzewissen = $uitvoerenwissen
                $onthoudkeuzebackup = $uitvoerenbackup
                "$infomelding_log" + "U heeft gekozen deze actie te herhalen bij andere studentmappen. " | out-file "$logbestand" -Append
                                }
            } else {
            # de keuze die is gemaakt wordt herhaald
                $uitvoerenwissen = $onthoudkeuzewissen
                $uitvoerenbackup = $onthoudkeuzebackup
                
            } # einde if not keuzeherhalen
        } # einde controleren of backup voor deze rpcnr al gemaakt is

        # als bestaande bestanden moeten worden gewist. 
        # Dit stukje is hetzelde als bij keuze "wissen" van deze switch-commando
        if ($uitvoerenwissen) {
            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "$doelmap" -Recurse -Force -ErrorAction Stop

                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        } # einde if uitvoerenwissen

        if ($uitvoerenbackup) {
            $error.clear()
            try {
                #backup maken
                Copy-Item -path "$bronmap" -destination "$doelmap" -recurse -Force -container -ErrorAction Stop

                # en daarna wissen als dit geselecteerd is
                if ($uitvoeren.wissennabackup -eq $true) { 
                    # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                    Remove-Item "$bronmap\mijn documenten\*" -Recurse -Force -ErrorAction Stop
                    # dan de root van rpc-map exclusief map mijn documenten
                    Remove-Item "$bronmap\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                    }
                } # einde try

            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch

        } # einde if uitvoerenbackup

    } # einde foreach rpcitem

    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    # $uitvoeren.listbox.selecteditems.clear()
               } # einde taak backup

    "kopiren" { 

    # array aanmaken en vullen met geselecteerde items. 
    # Deze items worden vervolgens gekopierd.
    $geselecteerdeitems = [System.Collections.ArrayList]@()

    <# Als er geen items zijn geselecteerd in de examenmap dan moet de gehele map worden gekopierd.
   hiervoor wordt dan de pad naar de examenmap toegevoegd aan de array $geselecteerdeitems.
   anders worden de geselecteerde items toegevoegd aan de array.
    #>
    if ($uitvoeren.listbox2.selecteditems.count -eq 0) {
        $bronmap = -join ($uitvoeren.bronmap,'\*')
        $geselecteerdeitems.Add("$bronmap")
        } else {
        foreach ($item in $uitvoeren.listbox2.selecteditems) {
            $bronmap = -join ($uitvoeren.bronmap,'\',$item)
            $geselecteerdeitems.Add("$bronmap")
        }
    }

    # variabele keuzeherhalen kan "true" worden bij functie kopieren_mapcontrole
    # standaard wordt de keuze niet herhaald
    $keuzeherhalen = $false

    #kopiren bestanden naar studentmappen

    foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ $rpcitem - FOUT ] : "
        $infomelding_log = "[ $rpcitem - INFO ] : "

        <# lokale variabelen nodig voor kopieertaak
           standaard wordt kopieren uitgevoerd
        #>
        $uitvoerenkopieren = $true
        $uitvoerenwissen = $false
        
        # doelmap bepalen. dit is een lokale variabele voor de deel-functies controleren, wissen en kopieren hieronder.
        $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
        $doelmaproot = -join ($uitvoeren.homemap,'\',$rpcitem)
    
        # nodig voor test-path
        $doelmaptest = -join ($doelmap,'\*')

        # controleren of een map inhoud heeft
        if (test-path "$doelmaptest" ) {
            # in logbestand info schrijven
            "$infomelding_log" + "Er zijn bestanden gevonden in deze map. " | out-file "$logbestand" -Append

            # controleren of er is gekozen om keuze te herhalen
            if (!($keuzeherhalen)) {

            # vragen wat te doen met bestanden in map
            $antwoordvraag, $keuzeherhalen = kopieren_mapcontrole "$rpcitem"
            if ($antwoordvraag -eq "wissen") { 
                $uitvoerenwissen = $true 
                "$infomelding_log" + "U heeft gekozen deze bestanden te wissen. " | out-file "$logbestand" -Append
                }
                elseif ($antwoordvraag -eq "overslaan") { 
                $uitvoerenkopieren = $false 
                "$infomelding_log" + "U heeft gekozen deze map over te slaan. " | out-file "$logbestand" -Append
                }
                else {
                "$infomelding_log" + "U heeft gekozen deze bestanden te behouden. " | out-file "$logbestand" -Append
                }

            if ($keuzeherhalen) {
                # onthouden van keuzes
                $onthoudkeuzewissen = $uitvoerenwissen
                $onthoudkeuzekopieren = $uitvoerenkopieren
                "$infomelding_log" + "U heeft gekozen deze actie te herhalen bij andere mappen. " | out-file "$logbestand" -Append
                                }
            } else {
            # de keuze die is gemaakt wordt herhaald
                $uitvoerenwissen = $onthoudkeuzewissen
                $uitvoerenkopieren = $onthoudkeuzekopieren
            } # einde if not keuzeherhalen
        } # einde controleren of een map inhoud heeft. 

        # als bestaande bestanden moeten worden gewist. 
        # Dit stukje is hetzelde als bij keuze "wissen" van deze switch-commando
        if ($uitvoerenwissen) {
            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "$doelmap\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "$doelmaproot\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        } # einde if uitvoerenwissen

        # kopieren geselecteerde mappen of bestanden, als dit moet worden uitgevoerd.
        if ($uitvoerenkopieren) {
            
            foreach ($item in $geselecteerdeitems) {
            $error.clear()
            try {
                Copy-Item -path "$item" -destination "$doelmap"  -recurse -ErrorAction Stop
                }

            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
            } # einde foreach $item
        } # einde if uitvoerenkopieren
    
    } # einde foreach $rpcitem

    # array legen. mss is dit niet nodig!
    $geselecteerdeitems.Clear()
    # geselecteerde rpc-nummers wissen. je moet dan opnieuw selecteren en kan niet meteen op bevestigen klikken.
    $uitvoeren.listbox.selecteditems.clear()

               } # einde taak kopiren

    "wissen"   { 
        #wissen van bestanden in studentmappen
        foreach ($rpcitem in $uitvoeren.listbox.selecteditems) {
            # progressie laten zien op balk
            $uitvoeren.progressbar.PerformStep()

            # teksten met meldingen voor het logbestand
            $foutmelding_log = "[ $rpcitem - FOUT ] : "
            $infomelding_log = "[ $rpcitem - INFO ] : "
            
            # doelmap bepalen. dit is een lokale variabele voor de deel-functie wissen hieronder.
            $doelmap = -join ($uitvoeren.homemap,'\',$rpcitem,'\Mijn Documenten')
            $doelmaproot = -join ($uitvoeren.homemap,'\',$rpcitem)

            $error.clear()
            try {
                # verwijderen van bestanden. Eerst de inhoud van mijn documenten
                Remove-Item "$doelmap\*" -Recurse -Force -ErrorAction Stop
                # dan de root van rpc-map exclusief map mijn documenten
                Remove-Item "$doelmaproot\*" -Recurse -Force -Exclude "mijn documenten" -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
            
            } # einde foreach statement

               } # einde taak wissen

    "verplaatsen" {
        # er is maar een actie te doen dus..
        $uitvoeren.progressbar.maximum = 1

        # teksten met meldingen voor het logbestand
        $foutmelding_log = "[ FOUT ] : "

        # definiren bron- en doelmap
        $bronmap = $uitvoeren.bronmap
        $doelmap = $uitvoeren.doelmap

        # doelmap wordt geleegd voor het verplaatsen of kopiren, als dit gekozen is.
        if ($uitvoeren.doelmaplegen -eq $true) {
            $error.clear()
            try {
                # verwijderen van bestanden in doelmap
                Remove-Item "$doelmap\*" -Recurse -Force -ErrorAction Stop
                }
            catch {

                # foutmelding van PowerShell naar logbestand
                "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
                $uitvoeren.foutmelding = $true
                  } # einde catch
        }

        # kopieren of verplaatsen
        $error.clear()
        try {
            # eerst kopiren
            Copy-Item -path "$bronmap" -destination "$doelmap" -recurse -ErrorAction Stop

            # verwijderen van bestanden als keuze is verplaatsen. alleen de inhoud van mijn documenten
            if ($uitvoeren.keuzeverplaatsen -eq "verplaatsen") {
                Remove-Item "$bronmap" -Recurse -Force -ErrorAction Stop
                }
            }
        catch {
              
              $uitvoeren.foutmelding = $true
              # foutmelding van PowerShell naar logbestand
              "$foutmelding_log" + $_.exception.message | out-file "$logbestand" -Append
              
              } # einde catch

        # progressie laten zien op balk
        $uitvoeren.progressbar.PerformStep()

                  } # einde taak verplaatsen

} # einde switch commando $uitvoeren.taak

}

function uitvoerentaken {
# hier worden de 4 belangrijkste taken uitgevoerd.

# controleren of mappen bestaan - afhankelijk van de taak
# map uitvoeren.homemap wordt in ieder geval gecontroleerd

if (!(test-path -path $uitvoeren.homemap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De homemappen van de studenten zijn niet gevonden!
    Controleer of de volgende map aanwezig is :

    $uitvoeren.homemap

    De taak kan nu niet uitgevoerd worden." "OK"
    return;
} # einde test voor map uitvoeren.homemap

if ($uitvoeren.taak -eq "kopiren") {
if (!(test-path -path $digitalebestanden -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
    Controleer of de volgende map aanwezig is :

    $digitalebestanden

    De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map digitalebestanden

if ($uitvoeren.taak -eq "backup") {
if (!(test-path -path $backupmap -pathtype container)) {
    $null = vraagvenster "Map bestaat niet" "De backupmap is niet gevonden!
    Controleer of de volgende map aanwezig is :

    $backupmap

    De taak kan nu niet uitgevoerd worden." "OK"
    return;
}
} # einde test voor map backupmap

# einde controleren of mappen bestaan

# startknop wordt onzichtbaar
$StartButton.Hide()
$Btnescape.Hide()


# het proces zichtbaar maken in een balk
$uitvoeren.progressbar = New-Object System.Windows.Forms.ProgressBar
$uitvoeren.progressbar.Location = New-Object System.Drawing.Point(20, 40)
$uitvoeren.progressbar.Size = New-Object System.Drawing.Size(560, 30)
$uitvoeren.progressbar.Style = "continuous"
# aantal geselecteerde rpcnrs bepaalt de maximumwaarde van de progressbar
$uitvoeren.progressbar.maximum = $listbox.selecteditems.count
$uitvoeren.progressbar.step = 1

# ProgressBar toevoegen aan form3
$uitvoeren.form3.Controls.Add($uitvoeren.progressbar);

# teksten en progressbar veranderen
$Label.hide()
$Description3.hide()
$Description2.ForeColor = 'red'
$Description2.Text = "De taak wordt uitgevoerd ..."
$uitvoeren.progressbar.visible

# datum bepalen
$datumvandaag = bepaaldatum;

# logbestandsnaam definiren en volledige pad naar bestand invoeren
# $logbestand = -join ("$logmap","\log_","$datumvandaag",".txt")
$logbestand = bepaallognaam "$datumvandaag"

# doorgeven aan hastable uitvoeren
$uitvoeren.logbestand = $logbestand

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

# map aanmaken voor logbestanden als deze niet bestaat
if (!(Test-Path "$logmap")) { mkdir "$logmap" } 

# in logbestand info over de taak schrijven en beginnen met uitvoeren van taak ---------------------------

"De taak " + $uitvoeren.taak + " is uitgevoerd." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append
$objtekst1.Text | out-file $logbestand -Append
if ($uitvoeren.taak -eq "kopiren") {
    $objtekst2.Text | out-file $logbestand -Append
    } elseif ($uitvoeren.taak -eq "backup") {
    if ($wissennabackup.checked -eq $true) { "De bestanden worden na de backup gewist." | out-file $logbestand -Append }
    } elseif ($uitvoeren.taak -eq "verplaatsen") {
    if ($keuzeoptie1.Selectedindex -eq "1") { 
        "U gaat bestanden kopiren van een rpc-nummer naar een andere." | out-file $logbestand -Append
        } else {
        "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." | out-file $logbestand -Append
        }
     if ($doelmaplegen.checked -eq $true) { 
        "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd." | out-file $logbestand -Append
                    } else {
        "De bestanden worden toegevoegd aan de bestanden in de doelmap." | out-file $logbestand -Append
                    }
    }


# ------ begin runspaces ----------------------------------------------

#Configure max thread count for RunspacePool.
$maxthreads = [int]$env:NUMBER_OF_PROCESSORS
    
#Create a new session state for parsing variables ie hashtable into our runspace.
$hashVars = New-object System.Management.Automation.Runspaces.SessionStateVariableEntry -ArgumentList 'uitvoeren',$uitvoeren,$Null
$InitialSessionState = [System.Management.Automation.Runspaces.InitialSessionState]::CreateDefault()
    
#Add the variable to the RunspacePool sessionstate
$InitialSessionState.Variables.Add($hashVars)

#Create our runspace pool. We are entering three parameters here min thread count, max thread count and host machine of where these runspaces should be made.
$script:runspace = [runspacefactory]::CreateRunspacePool(1,$maxthreads,$InitialSessionState, $Host)

#Create a PowerShell instance.
$script:powershell = [powershell]::Create()
    
#Open a RunspacePool instance.
$script:runspace.Open()
         
#Add our main code to be run via $scriptRun within our RunspacePool.
$script:powershell.AddScript(${Function:scriptRun})
$script:powershell.RunspacePool = $script:runspace
        
#Run our RunspacePool.
$script:handle = $script:powershell.BeginInvoke()

#Wait for code to complete and keep UI responsive
do {
		[System.Windows.Forms.Application]::DoEvents()
		Start-Sleep -Milliseconds 1 
} while (!$script:handle.IsCompleted)

#Cleanup our RunspacePool threads when they are complete ie. GC.
if ($script:handle.IsCompleted)
        {
            $script:powershell.EndInvoke($script:handle)
            $script:powershell.Dispose()
            $script:runspace.Dispose()
            $script:runspace.Close()
            "--- is completed -- " 
            [System.GC]::Collect()
        }

# ----- Einde runspaces -----------------------------------------------

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = get-date -Format "HH:mm:ss"


"" | out-file $logbestand -Append
"Eindtijd  : $logtijd" | out-file $logbestand -Append
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"" | out-file $logbestand -Append

# aangeven dat taken zijn uitgevoerd 
if ($uitvoeren.foutmelding) { $Description2.Text = "De taak is niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $Description2.Text = "De taak is uitgevoerd." }

# knoppen zichtbaar maken
$EndButton.show()
$LogButton.show()

# alleen bij taak kopieren onderstaande knop zichtbaar maken
if ($uitvoeren.taak -eq "kopiren") {
    $Btnescape.size = New-Object System.Drawing.Size(200,40)
    # escape knop wordt nu opnieuw knop
    $Btnescape.text= "Opnieuw bestanden klaarzettenn"
    $Btnescape.BackColor = 'green'
    $Btnescape.show()
} else {
# knop logbestand bekijken wordt nu naar links verplaatst om aan te sluiten met knop sluiten.
$LogButton.Location = New-Object System.Drawing.Size(160, 400)
}

}

function overzichttaken ([string]$taak) {
# na het bevestigen van je keuze bij een van de 4 taken kom je bij deze functie.
# hier zie je een overzicht en kan je de taak starten of nog terug.

# hashtable object leeg maken voor het geval het nog waarden heeft.
$uitvoeren.clear()

# definiren venster
$uitvoeren.Form3                  = New-Object system.Windows.Forms.Form
$uitvoeren.Form3.ClientSize       = New-Object System.Drawing.Point(600,460)
$uitvoeren.Form3.text             = "Overzicht uit te voeren taak"
$uitvoeren.Form3.TopMost          = $false
$uitvoeren.Form3.StartPosition    = 'CenterScreen'

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.AutoSize            = $false
$Description2.width               = 570
$Description2.height              = 20
$Description2.location            = New-Object System.Drawing.Point(20,10)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor           = 'blue'

# onderstaande tekst wordt alleen zichtbaar als backuptaak is gekozen en wissen na backup is geselecteerd.
$Description3                     = New-Object system.Windows.Forms.Label
$Description3.AutoSize            = $false
$Description3.width               = 500
$Description3.height              = 20
$Description3.location            = New-Object System.Drawing.Point(20,28)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.Text                = "De bestanden worden na de backup gewist."
$Description3.ForeColor           = 'blue'
$Description3.hide()

$StartButton = New-Object System.Windows.Forms.Button
$StartButton.Location = New-Object System.Drawing.Size(10, 400)
$StartButton.Size = New-Object System.Drawing.Size(120, 50)
$StartButton.Text = "Start"
$StartButton.height = 40
$StartButton.BackColor = 'green'
$StartButton.ForeColor = 'white'
$StartButton.Add_click( {
    # toevoegen object en variabelen aan hastable voor uitvoeren 
    $uitvoeren.taak=$taak
    $uitvoeren.logbestand=$logbestand
    $uitvoeren.homemap=$homemapstudenten
    $uitvoeren.listbox = New-Object System.Windows.Forms.Listbox
    $uitvoeren.listbox = $listbox

    <# specifieke variabelen voor de gegeven taak.
       o.a. toevoegen tekst aan variabele uitvoeren.logbestandtekst om in logbestand te plaatsen
    #>
    switch ($taak) {

        "kopiren" {
        $uitvoeren.listbox2 = New-Object System.Windows.Forms.Listbox
        $uitvoeren.listbox2 = $listbox2
        $uitvoeren.bronmap = -join ($digitalebestanden,"\",$keuzecrebonr,"\",$keuzekerntaak,"\",$keuzeexamen)
        # $uitvoeren.logbestandtekst = $uitvoeren.logbestandtekst + "`r`n" + $objtekst2.Text
        }

        "backup" {
        $uitvoeren.doelmap="$backupmap"
        $uitvoeren.wissennabackup=$wissennabackup.checked
        }

        "verplaatsen" {
        # bepalen doel-, bronmap en doelmaplegen
        $uitvoeren.bronmap = -join ($homemapstudenten,"\",$bronselectie.selecteditem,"\Mijn Documenten\*")
        $uitvoeren.doelmap = -join ($homemapstudenten,"\",$doelselectie.selecteditem,"\Mijn Documenten")
        $uitvoeren.doelmaplegen=$doelmaplegen.checked
        # keuze tussen kopieren of verplaatsen doorgeven
        if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $uitvoeren.keuzeverplaatsen = "kopiren" 
                    } else {
                    $uitvoeren.keuzeverplaatsen = "verplaatsen" 
                    }
        }
    } # einde switch $taak

    uitvoerentaken;
    
    });

$EndButton = New-Object System.Windows.Forms.Button
$EndButton.Location = New-Object System.Drawing.Size(10, 400)
$EndButton.Size = New-Object System.Drawing.Size(120, 50)
$EndButton.Text = "Sluiten"
$EndButton.height = 40
$EndButton.BackColor = 'blue'
$EndButton.ForeColor = 'white'
$EndButton.DialogResult = [System.Windows.Forms.DialogResult]::OK
$EndButton.hide()

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Terug"
$Btnescape.location = New-Object System.Drawing.Size(160, 400)
$Btnescape.size = New-Object System.Drawing.Size(120, 50)
$Btnescape.height = 40
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(400, 400)
$LogButton.Size = New-Object System.Drawing.Size(170, 50)
$LogButton.Text = "Logbestand bekijken"
$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.close()
    $uitvoeren.Form3.close()
    vensterlogbestand })

$Label = New-Object System.Windows.Forms.Label
$Label.Font = 'Microsoft Sans Serif,12'
$Label.ForeColor = 'blue'
$Label.Text = "Klaar om de taak uit te voeren ?"
$Label.Location = New-Object System.Drawing.Point(20, 50)
$Label.Width = 480
$Label.Height = 20

switch ($taak) {
    "backup"      { 
                  $Description2.text = "U gaat een backup uitvoeren op de volgende rpc-nummers." 
                  if ($wissennabackup.checked -eq $true) { 
                    $Description3.text = "De bestanden worden na de backup gewist."
                    $Description3.show() 
                    }
                  }
    "kopiren"    { $Description2.text = "U gaat bestanden of mappen klaarzetten op de volgende rpc-nummers." }
    "wissen"      { $Description2.text = "U gaat bestanden wissen van de volgende rpc-nummers." }
    "verplaatsen" { 
                  if ($keuzeoptie1.Selectedindex -eq "1") { 
                    $Description2.text = "U gaat bestanden kopiren van een rpc-nummer naar een andere." 
                    } else {
                    $Description2.text = "U gaat bestanden verplaatsen van een rpc-nummer naar een andere." 
                    }
                  $Description3.show() 
                  if ($doelmaplegen.checked -eq $true) { 
                    $Description3.text = "De doelmap wordt voor het verplaatsen of kopiren eerst geleegd."
                    } else {
                    $Description3.text = "De bestanden worden toegevoegd aan de bestanden in de doelmap."
                    }
                  }
}

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,80) 
$objtekst1.Size = New-Object System.Drawing.Size(200,290)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = "Geselecteerde rpc-nummers:" + "`r`n" + "`r`n"
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"

$objtekst2 = New-Object System.Windows.Forms.textbox
$objtekst2.Location = New-Object System.Drawing.Size(230,80) 
$objtekst2.Size = New-Object System.Drawing.Size(350,290)
$objtekst2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst2.Text = ""
$objtekst2.ReadOnly = $true
$objtekst2.Multiline = $true
$objtekst2.ScrollBars = "Both"
$objtekst2.Visible = $false

# geselecteerde rpc-nummers links weergeven
# als taak is verplaatsen heb je een andere inhoud dan bij overige taken
if ($taak -eq "verplaatsen") {
    $objtekst1.Text = $objtekst1.Text + " Bron is " + $bronselectie.selecteditem + "`r`n" + "`r`n"
    $objtekst1.Text = $objtekst1.Text + " Doel is " + $doelselectie.selecteditem + "`r`n"
    } else {
    foreach ($item in $listbox.selecteditems) {
        $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
        }
    }

# geselecteerde mappen bij taak kopiren rechts weergeven. alleen als taak kopieren is geslecteerd
if ($taak -eq "kopiren") {
    $objtekst2.Text = "Geselecteerde bestanden of mappen:" + "`r`n" + "`r`n"
    $objtekst2.Visible = $true

    if ($listbox2.selecteditems.count -eq 0) {
        $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" + "`r`n"

        } else {
        foreach ($item in $listbox2.selecteditems) {
            $objtekst2.Text = $objtekst2.Text + " - " + "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\$item" + "`r`n"
            }
        }
    }

$uitvoeren.Form3.Controls.AddRange(@($Description2, $Description3, $StartButton, $EndButton, $Btnescape, $LogButton, $Label, $objtekst1, $objtekst2 ))

$result = $uitvoeren.form3.ShowDialog()

$uitvoeren.Form3.Close()

if ($result -eq [system.windows.forms.dialogResult]::OK) { 
    $Form2.Close()
    $form.show()
    }

}

function startknopklikbaar {
# deze functie wordt alleen gebruikt bij functie Vensterkopieren
# en bepaald of knoppen en items van vensterkopieren zichtbaar moeten zijn

# start knop
if (($global:listbox.selecteditems.count -gt 0) -and ($lijstexamens.selecteditem -ne $null)) {
    $Btnstart.Enabled= $true
} else {
    $Btnstart.Enabled= $false
}

}

function vensterkopieren { 
# taak bestanden overzetten begint hier

# variabelen

[string]$global:keuzecrebonr=""
[string]$global:keuzekerntaak=""
[string]$global:keuzeexamen=""
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

if (!(test-path -path "$digitalebestanden")) {
    $null = vraagvenster "Map bestaat niet" "De map met de te kopiren bestanden is niet gevonden!
Controleer of de volgende map aanwezig is :

$digitalebestanden

De taak kan nu niet opgestart worden." "OK" 
    return;
}

if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :

$homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}


# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# De hoofdmenu onzichtbaar maken
$form.Hide()

$Form2                            = New-Object system.Windows.Forms.Form
$Form2.ClientSize                 = New-Object System.Drawing.Point(900,600)
$Form2.text                       = "Bestanden klaarzetten in de studentmappen"
$Form2.TopMost                    = $false
$Form2.StartPosition              = 'CenterScreen'

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Selecteer in het midden de locatie, crebonummer, kerntaak en examen en selecteer links de rpc-nummers.
Eventueel kunt u alleen enkele mappen of bestanden van een examen in het middelste vakje selecteren. 
Klik op bevestigen om door te gaan."

$Description2.AutoSize            = $false
$Description2.width               = 850
$Description2.height              = 52
$Description2.location            = New-Object System.Drawing.Point(20,15)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer de locatie."
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 42
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.location            = New-Object System.Drawing.Point(550,80)
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Selecteer de crebonummer."
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(550,120)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Selecteer de kerntaak."
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(550,160)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description8                     = New-Object system.Windows.Forms.Label
$Description8.text                = "Selecteer het examen."
$Description8.AutoSize            = $false
$Description8.width               = 400
$Description8.height              = 42
$Description8.Font                = 'Microsoft Sans Serif,11'
$Description8.location            = New-Object System.Drawing.Point(550,200)
$Description8.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Inhoud van geselecteerde examenmap :"
$Description6.AutoSize            = $false
$Description6.width               = 330
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(200,250)
$Description6.ForeColor  = [System.Drawing.Color]::Blue

$Description7                     = New-Object system.Windows.Forms.Label
$Description7.text                = "Inhoud van geselecteerde map in examenmap :"
$Description7.AutoSize            = $false
$Description7.width               = 400
$Description7.height              = 42
$Description7.Font                = 'Microsoft Sans Serif,11'
$Description7.location            = New-Object System.Drawing.Point(550,250)
$Description7.ForeColor = [System.Drawing.Color]::Blue
$Description7.Hide()

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,550" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "kopiren" }) 

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,550" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

# listbox is al in het begin gedeclareerd. onderstaande waarden gelden voor deze functie.
$listBox.Location = New-Object System.Drawing.Point(10,80)
$listBox.Size = New-Object System.Drawing.Size(160,460)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'

# bij aanklikken van een rpcnr, kijken of startknop weergegeven kan worden
$listbox.add_SelectedIndexChanged(
     { startknopklikbaar;
     } )

$global:listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(200,279)
$listBox2.Size = New-Object System.Drawing.Size(330,260)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.SelectionMode = 'MultiExtended'
$listBox2.items.clear()

# bij aanklikken van een map, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged(
     { 
     # selectie krijgt waarde van volledige pad naar gekozen map
     $selectie = "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen\" + $ListBox2.SelectedItem

     # alleen als 1 item is geselecteerd EN geselecteerde een map is
     if (($listbox2.selecteditems.count -eq 1) -and ((test-path -path $selectie -pathtype container) -eq $true) ) {
          
          # zichtbaar maken
          $objtekst1.Visible = $true
          $Description7.show()
          # tekstbox inhoud geven
          $objtekst1.Text = ""   

          # weergeven inhoud in tekstbox
          # eerst de volledige inhoud van de map krijgen
          $volledigetext= Get-ChildItem -Path "$selectie"
          # dan netjes in rijen plaatsen.
          foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + " - " + "$item" + "`r`n"
               }
          startknopklikbaar;

          } else {
          # venster met inhoud map onzichtbaar maken
          $objtekst1.Visible = $false
          $Description7.Hide()
          }
    }
    )

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(550,279) 
$objtekst1.Size = New-Object System.Drawing.Size(330,245)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"
$objtekst1.Hide()

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 330
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,80) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     startknopklikbaar;
     } ) 

$lijstcrebonrs                     = New-Object system.Windows.Forms.ComboBox
$lijstcrebonrs.text                = "Kies een crebonummer"
$lijstcrebonrs.width               = 330
$lijstcrebonrs.autosize            = $true
$lijstcrebonrs.Location = New-Object System.Drawing.Size(200,120) 
$lijstcrebonrs.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstcrebonrs.DropDownStyle="DropDownList"

# crebonummers in de lijst zetten. 
Get-ChildItem -Path $digitalebestanden -Directory -Name | ForEach-Object {[void] $lijstcrebonrs.Items.Add($_)}

# uitvoeren als selectie van crebonummer wijzigt
$lijstcrebonrs.add_SelectedIndexChanged(
     { 
     $lijstkerntaken.items.clear()
     $lijstexamens.items.clear()
     $listBox2.items.clear()
     $objtekst1.Visible = $false
     $Description7.Hide()
     $global:keuzecrebonr = $lijstcrebonrs.selecteditem

     Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr" -Directory -Name | ForEach-Object {[void] $lijstkerntaken.Items.Add($_)}

     startknopklikbaar;
     } )

$lijstkerntaken                     = New-Object system.Windows.Forms.ComboBox
$lijstkerntaken.text                = "Kies een kerntaak"
$lijstkerntaken.width               = 330
$lijstkerntaken.autosize            = $true
$lijstkerntaken.Location = New-Object System.Drawing.Size(200,160) 
$lijstkerntaken.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstkerntaken.DropDownStyle="DropDownList"

# uitvoeren als selectie van kerntaken wijzigt
$lijstkerntaken.add_SelectedIndexChanged(
    {
    $lijstexamens.items.clear()
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzekerntaak = $lijstkerntaken.selecteditem

    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak" -Directory -Name | ForEach-Object {[void] $lijstexamens.Items.Add($_)}

    startknopklikbaar;
    } )

$lijstexamens                     = New-Object system.Windows.Forms.ComboBox
$lijstexamens.text                = "Kies een examen"
$lijstexamens.width               = 330
$lijstexamens.autosize            = $true
$lijstexamens.Location = New-Object System.Drawing.Size(200,200) 
$lijstexamens.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstexamens.DropDownStyle="DropDownList"

# uitvoeren als selectie van examens wijzigt
$lijstexamens.add_SelectedIndexChanged(
    {
    
    $listBox2.items.clear()
    $objtekst1.Visible = $false
    $Description7.Hide()

    $global:keuzeexamen = $lijstexamens.selecteditem
    
    Get-ChildItem -Path "$digitalebestanden\$keuzecrebonr\$keuzekerntaak\$keuzeexamen" -Name | ForEach-Object {[void] $listbox2.Items.Add($_)}

    startknopklikbaar;
    } )


startknopklikbaar;

$Form2.controls.AddRange(@($listBox, $lijstcrebonrs, $lijstkerntaken, $lijstexamens, $lijstlocaties, $listBox2, $Btnstart, $Btnescape, $objtekst1, $Description2, 
$Description3, $Description4, $Description5, $Description6, $Description7, $Description8 ))

#$form2.Topmost = $true
$form2.Topmost = $false

$null = $form2.ShowDialog()
    
$form2.close();
# $form2.hide();

# De hoofdmenu zichtbaar maken
$form.show()

}

function vensterbackup {
# taak backuppen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten" )) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :

$homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

if (!(test-path -path "$backupmap" )) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!
Controleer of de volgende map aanwezig is :

$backupmap

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,650)
$form2.text                       = "Backup van bestanden in de studentmappen"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer hieronder de rpc-nummers. Klik op Bevestigen om door te gaan."
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Kies eventueel als eerst je locatie."
$Description4.AutoSize            = $false
$Description4.width               = 300
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(280,50)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "backup" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel


# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,90)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 430

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$wissennabackup = New-Object System.Windows.Forms.Checkbox 
$wissennabackup.Location = New-Object System.Drawing.Point(50,580)
$wissennabackup.Size = New-Object System.Drawing.Size(500,30)
$wissennabackup.Text = "Bestanden na de backup ook wissen"
$wissennabackup.Font = 'Microsoft Sans Serif,11'
$wissennabackup.ForeColor = [System.Drawing.Color]::green

if (($global:init["algemeen"]["wissennabackup"]) -eq "ja") {
    $wissennabackup.checked = $true
    } else {
    $wissennabackup.checked = $false
    }

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,50) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $wissennabackup, $Description3, $Description4 ))
$form2.Topmost = $false

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
}

function vensterwissen {
# taak wissen begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :

$homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# rpcnrs declareren met een function
$global:listBox = declareren_rpcnrs;
$global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,600)
$form2.text                       = "Wissen van bestanden in de studentmappen"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Selecteer hieronder de rpc-nummers. Klik op Bevestigen om door te gaan."
$Description3.AutoSize            = $false
$Description3.width               = 800
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(20,15)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Kies eventueel als eerst je locatie."
$Description4.AutoSize            = $false
$Description4.width               = 300
$Description4.height              = 42
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.location            = New-Object System.Drawing.Point(280,50)
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,540" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "wissen" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,540" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape

# listbox is in het begin al gedeclareerd.
$listBox.Location = New-Object System.Drawing.Point(10,90)
$listBox.Size = New-Object System.Drawing.Size(260,20)
$listBox.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox.SelectionMode = 'MultiExtended'
$listBox.Height = 430

# start knop zichtbaar of niet
$listbox.add_SelectedIndexChanged(
     { 
     if ($listbox.selecteditems.count -gt 0) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(10,50) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $global:listBox = lijstrpcnrsaanmaken $keuzelocatie $global:listBox 
     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$form2.controls.AddRange(@($lijstlocaties, $listBox, $Btnstart, $Btnescape, $Description3, $Description4 ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdvenster zichtbaar maken
$form.show()
}

function vensterverplaatsen {
# taak verplaatsen van bestanden begint hier

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

$keuzedoelmaplegen=$global:init["algemeen"]["maplegenvoorverplaatsen"]


# controleren of de mappen beschikbaar zijn
if (!(test-path -path "$homemapstudenten")) {
    $null = vraagvenster "Map bestaat niet" "De home-map van de studenten is niet gevonden!
Controleer of de volgende map aanwezig is :

$homemapstudenten

De taak kan nu niet opgestart worden." "OK"
    return;
}

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,410)
$form2.text                       = "Verplaatsen of kopiren van bestanden naar een andere studentmap"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Geef aan in welke rpc-nummer de bestanden staan, dit is de bron, 
en naar welke rpc-nummer de bestanden worden gekopierd, dit is het doel. 
Klik op Bevestigen om door te gaan."
$Description4.AutoSize            = $false
$Description4.width               = 580
$Description4.height              = 70
$Description4.location            = New-Object System.Drawing.Point(20,15)
$Description4.Font                = 'Microsoft Sans Serif,12'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Kies de bron :"
$Description2.AutoSize            = $false
$Description2.width               = 150
$Description2.height              = 50
$Description2.location            = New-Object System.Drawing.Point(20,190)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Kies het doel :"
$Description3.AutoSize            = $false
$Description3.width               = 150
$Description3.height              = 50
$Description3.location            = New-Object System.Drawing.Point(20,240)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Kies eventueel je locatie :"
$Description5.AutoSize            = $false
$Description5.width               = 300
$Description5.height              = 42
$Description5.Font                = 'Microsoft Sans Serif,11'
$Description5.location            = New-Object System.Drawing.Point(20,90)
$Description5.ForeColor = [System.Drawing.Color]::Blue

$Description6                     = New-Object system.Windows.Forms.Label
$Description6.text                = "Kies de gewenste taak :"
$Description6.AutoSize            = $false
$Description6.width               = 300
$Description6.height              = 42
$Description6.Font                = 'Microsoft Sans Serif,11'
$Description6.location            = New-Object System.Drawing.Point(20,140)
$Description6.ForeColor = [System.Drawing.Color]::Blue

$Btnstart = New-object System.Windows.Forms.Button 
$Btnstart.text= "Bevestigen"
$Btnstart.location = "50,360" 
$Btnstart.size = "150,30"  
$BtnStart.BackColor = 'green'
$BtnStart.ForeColor = 'white'
$Btnstart.Add_Click({ overzichttaken "verplaatsen" }) 
$Btnstart.Enabled= $false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,360" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel
$form2.cancelbutton = $Btnescape

# de selectie vd de bron
$bronselectie                     = New-Object system.Windows.Forms.ComboBox
$bronselectie.width               = 260
$bronselectie.autosize            = $true
$bronselectie.DropDownStyle       = "DropDownList"
$bronselectie.Font                = 'Microsoft Sans Serif,12'
$bronselectie.location = "200,190" 

$bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie

#  de selectie vd de doel rpc-nummer 
$doelselectie                     = New-Object system.Windows.Forms.ComboBox
$doelselectie.width               = 260
$doelselectie.autosize            = $true
$doelselectie.DropDownStyle       = "DropDownList"
$doelselectie.Font                = 'Microsoft Sans Serif,12'
$doelselectie.location = "200,240" 

$doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

#  de keuze vd taak
$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 260
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "200,140" 
[void] $keuzeoptie1.Items.Add("Verplaatsen")
[void] $keuzeoptie1.Items.Add("Kopiren")
$keuzeoptie1.Selectedindex = 0



# start knop zichtbaar of niet bij bron- en doelselectie
# controle of dezelfde rpc-nr isgekozen

$doelselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $doelselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
    if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$bronselectie.add_SelectedIndexChanged(
     { 
    # kijken of dezelfde selectie is gemaakt en zo ja, opheffen
    if ($doelselectie.selecteditem -eq $bronselectie.selecteditem) { 
        $bronselectie.selecteditem = $null
        }
    # kijken of startknop zichtbaar mag zijn
     if (($doelselectie.selecteditem -ne $null) -and ($bronselectie.selecteditem -ne $null)) {
        $Btnstart.Enabled= $true
        } else {
        $Btnstart.Enabled= $false
        }  
    } )

$lijstlocaties                     = New-Object system.Windows.Forms.ComboBox
$lijstlocaties.text                = "Kies je locatie"
$lijstlocaties.width               = 260
$lijstlocaties.autosize            = $true
$lijstlocaties.Location = New-Object System.Drawing.Size(200,90) 
$lijstlocaties.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$lijstlocaties.DropDownStyle="DropDownList"

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    $waarde=$global:locaties.$_.naam
    [void] $lijstlocaties.Items.Add("$_ - $waarde")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $lijstlocaties.Selectedindex = $teller }
    $teller++
    }

# bij wijzigen van selectie lijstlocaties
$lijstlocaties.add_SelectedIndexChanged(
     { 
     [string]$waarde = $lijstlocaties.selecteditem
     $keuzelocatie = $waarde.Substring(0,3)

     # nieuwe rpcnrs declareren
     $bronselectie = lijstrpcnrsaanmaken $keuzelocatie $bronselectie
     $doelselectie = lijstrpcnrsaanmaken $keuzelocatie $doelselectie

     # selectie van bron en doel ophefen
     $doelselectie.selecteditem = $null
     $bronselectie.selecteditem = $null

     # startknop niet klikbaar maken
     $Btnstart.Enabled= $false
     } ) 

$doelmaplegen = New-Object System.Windows.Forms.Checkbox 
$doelmaplegen.Location = New-Object System.Drawing.Point(20,290)
$doelmaplegen.Size = New-Object System.Drawing.Size(500,30)
$doelmaplegen.Text = "Doelmap legen voor het verplaatsen of kopiren."
$doelmaplegen.Font = 'Microsoft Sans Serif,12'
$doelmaplegen.ForeColor = [System.Drawing.Color]::Green
if ($keuzedoelmaplegen -eq "ja") {
    $doelmaplegen.Checked = $true
    } else {
    $doelmaplegen.Checked = $false
    }


$form2.controls.AddRange(@($lijstlocaties, $keuzeoptie1, $bronselectie, $doelselectie, $doelmaplegen, $Btnstart, $Btnescape, $Description2, $Description3, $Description4, $Description5, $Description6 ))

$null = $form2.ShowDialog()
    
$form2.close();

# De hoofdmvenster zichtbaar maken
$form.show()
}

function programmaafsluiten {
# een venster met de vraag of je zeker het programma wilt sluiten

$result = vraagvenster "Afsluiten?" "
          U gaat het programma sluiten. 

          Weet u het zeker?" "Ja" "Nee"

# if ($result -eq 'Yes') {

if ($result -eq 'Ok') {
    # programma sluiten
    $form.dispose()
}

}

function vensterlogbestand {
# de taak logbestand bekijken begint hier

# controle of er logbestanden zijn
if (!(Test-Path -Path "$logmap\*.txt")) {
    $null = vraagvenster "Geen logbestanden" "
    
Er zijn geen logbestanden om te weergeven."
    return;
    }

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(1100,650)
$form2.text                       = "Logbestanden bekijken"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Selecteer links de datum van het logbestand dat je wilt bekijken. Rechts wordt dan de inhoud weergegeven.
Eventueel kunt u filteren op jaar en maand."
$Description1.AutoSize            = $false
$Description1.width               = 800
$Description1.height              = 42
$Description1.location            = New-Object System.Drawing.Point(20,15)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Filter op jaar"
$Description2.AutoSize            = $false
$Description2.width               = 100
$Description2.height              = 42
$Description2.location            = New-Object System.Drawing.Point(20,63)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "en op maand"
$Description3.AutoSize            = $false
$Description3.width               = 100
$Description3.height              = 42
$Description3.location            = New-Object System.Drawing.Point(210,63)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$filterjaar                     = New-Object system.Windows.Forms.ComboBox
$filterjaar.width               = 70
$filterjaar.autosize            = $true
$filterjaar.DropDownStyle       = "DropDownList"
$filterjaar.Font                = 'Microsoft Sans Serif,12'
$filterjaar.location = "120,60" 
# vullen met jaren
for ($i=2022; $i -le 2040; $i++) {
    [void] $filterjaar.Items.Add($i)
}
$filterjaar.add_SelectedIndexChanged({
    $filtermaand.Enabled = $true
    $filtermaand.selecteditem = $null
    $listbox2.Items.clear()

    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"

        if ($datumlog.Contains($filterjaar.selecteditem)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})

$filtermaand                     = New-Object system.Windows.Forms.ComboBox
$filtermaand.width               = 50
$filtermaand.autosize            = $true
$filtermaand.DropDownStyle       = "DropDownList"
$filtermaand.Font                = 'Microsoft Sans Serif,12'
$filtermaand.location = "320,60" 
$filtermaand.Enabled = $false
# vullen met maanden
for ($i=01; $i -le 12; $i++) {
    if ($i -lt 10) {
        [void] $filtermaand.Items.Add("0$i")
        } else {
        [void] $filtermaand.Items.Add("$i")
        }
}
$filtermaand.add_SelectedIndexChanged({
    $listbox2.Items.clear()

    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
        $datumlog = bepaaldatumuitlognaam "$_"
        $filter = -join ($filterjaar.selecteditem,"-",$filtermaand.selecteditem)
        if ($datumlog.Contains($filter)) { 
            [void] $listbox2.Items.Add($datumlog)
        }
    }
    if ($listbox2.Items.count -gt 0) { $listBox2.SelectedIndex = 0 }
        else { $objtekst1.Text = "" }
})

$filterwissen = New-object System.Windows.Forms.Button 
$filterwissen.text= "Filters wissen"
$filterwissen.location = "400,60" 
$filterwissen.size = "150,30"  
$filterwissen.BackColor = 'blue'
$filterwissen.ForeColor = 'white'
$filterwissen.add_click({
    
    $filtermaand.selecteditem = $null
    $filterjaar.selecteditem = $null
    $filtermaand.Enabled = $false

    $listbox2.Items.clear()
    Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)        
    }
    # eerste logbestand is geselecteerd.
    $listBox2.SelectedIndex = 0
})

$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,600" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'blue'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok

$listBox2 = New-Object System.Windows.Forms.Listbox
$listBox2.Location = New-Object System.Drawing.Point(10,110)
$listBox2.Size = New-Object System.Drawing.Size(120,20)
$listBox2.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$listBox2.Height = 475

# bij aanklikken van een datum, inhoud weergeven in venster ernaast
$listbox2.add_SelectedIndexChanged( {
    $objtekst1.Text = ""
    # datum omzetten naar bestandsnaam
    $gekozendatum = bepaallognaam $ListBox2.SelectedItem
    # inhoud bestand inlezen
    $volledigetext = Get-Content -Path "$gekozendatum"
    # dan netjes in rijen plaatsen.
    foreach ($item in $volledigetext) {
               $objtekst1.Text = $objtekst1.Text + "$item" + "`r`n"
               }
    } )

# inhoud van logmap weergeven met listbox2
Get-ChildItem -Path "$logmap\*.txt" -Name | Sort-Object -Descending | ForEach-Object {
    $datumlog = bepaaldatumuitlognaam "$_"
    [void] $listbox2.Items.Add($datumlog)
    }

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(150,110) 
$objtekst1.Size = New-Object System.Drawing.Size(880,462)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"

$Form2.Controls.AddRange(@($Description1, $Description2, $Description3, $filterjaar, $filtermaand, $filterwissen, $Buttenok, $listbox2, $objtekst1 ))

# eerste logbestand is geselecteerd.
$listBox2.SelectedIndex = 0

$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()
}

function updatevoorbereiden ($opgestart) {
<# de taak updaten begint hier

 variabelen voor deze functie
 $opgestart geeft aan hoe dit is aangeroepen: auto of keuzemenu
#>

<# $huidigeversie wordt alleen in deze functie gebruikt en is er om te verduidelijken dat dit de huidge versie is en
   om niet overal "global:" voor te zetten. $versie is namelijk een global variabele.
#>
$huidigeversie = $global:versie

# updaten naar een versie. "uptodate" betekent geen update nodig, 
$updateto="uptodate"
# of deze versie verouderd is
$deprecated = $false
# pad naar updateinfo op lokale pc
$updateinfobestand = -join ("$startmap","\","$global:updateinfo")
# bepalen downloadbestand
$downloadbestand = -join ("$updatewebsite","/updates/","$global:updateinfo")
# $autoupdate is afhankelijk van instelling in initialisatiebestand
if ($global:init["algemeen"]["autoupdate"] -eq "ja") {
    $autoupdate = $true 
    } else {
    $autoupdate = $false
    }

<# controleren of een update is uitgevoerd en zo ja verwijderen bestand
   zo kan ga je niet na een update, opnieuw updaten
   als je bent opgestart via hoofdvenster dan niet afsluiten
#>
if (test-path -path $updateinfobestand -pathtype leaf) { 
    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "begin")  { return }
    }

# downloaden updateinfobestand van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$updateinfobestand" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update-informatie niet kunnen downloaden!  
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update-informatie niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }
      
# inlezen updateinfobestand en controleren op een update ...

# inlezen ini-bestand naar object
$global:updateini = Get-IniContent $updateinfobestand

# controleren of versie verouderd is
if ("$huidigeversie" -le $updateini["deprecated"]["old"]) { $deprecated = $true }

# controleren op revisie en anders op laatste versie 
if ($updateini["revision"].Contains($huidigeversie) ) {
    $updateto = $updateini["revision"]["$huidigeversie"]
    } else {
    
    if ("$huidigeversie" -lt $updateini["program"]["latest"]) {
        $updateto = $updateini["program"]["latest"]
        }
} 
# einde controles. er is bepaald of er een update is.

# programma is up to date?
if ($updateto -eq "uptodate") {

    Remove-Item "$updateinfobestand" 
    if ($opgestart -eq "keuzemenu")  { 
        $null = vraagvenster "Geen update nodig" "
        Een update is niet nodig.
        Het programma heeft de laatste versie." "OK"
        }
    return
}

# Er is een update beschikbaar

# afhankelijk van opstartkeuze en autoupdate, melding geven of doorgaan.
if ($opgestart -eq "keuzemenu") {

    $result = vraagvenster "Er is een update beschikbaar" "
Er is een nieuwe versie van dit programma beschikbaar.

Updaten naar versie $updateto ?" "Ja" "Nee"
    if ($result -eq "Cancel") { 
        Remove-Item "$updateinfobestand" 
        return 
        }
    } else {

    if (! ($autoupdate) ) { 
        Remove-Item "$updateinfobestand" 

        if ($global:init["algemeen"]["updatenotificatie"] -eq "ja" ) {

        if ($deprecated) {
            $messageboxtekst = "Er is een nieuwe versie van dit programma beschikbaar.

Kies in het hoofdvenster 'Controleren op een update' 
of zet deze melding bij 'Instellingen' voortaan uit.
U wordt echter aangeraden deze te installeren omdat de huidige versie verouderd is."
            } else {
            $messageboxtekst = "Er is een nieuwe versie van dit programma beschikbaar. 

Kies in het hoofdvenster 'Programma updaten'
of zet deze melding bij 'Instellingen' voortaan uit."
            }
        $null = vraagvenster "Er is een update beschikbaar" "$messageboxtekst" "Ok"

        } # einde if $updateini["algemeen"]["updatenotificatie"]

        return
        } # einde if (! ($autoupdate) )
    } # einde if opgestart ... else

# variabelen die nodig zijn voor het downloaden. 
# bestand met update die gedownload wordt
$zip_download = "beherenbestanden_$updateto.zip"
# pad naar bestand met update op de website
$downloadbestand = bepaalversiemap "$updateto"
# pad naar bestand met update op de website, samenvoegen met update die gedownload wordt
$downloadbestand = -join ("$downloadbestand","/","$zip_download")
# pad naar bestand met update op lokale pc
$zip_download = -join ("$startmap","\","$zip_download")

# downloaden zip_download van website en foutmeldingen opvangen
$error.clear()
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$zip_download" -ErrorAction Stop
    }
catch {
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Bestand met update niet kunnen downloaden! 
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Bestand met update niet kunnen downloaden! "
        Start-Sleep -s 3
        }
    return
    }

# tempmap aanmaken. als deze al bestaat wordt geen melding gegeven.
# vervolgens leeg maken
$tempmap = "$startmap\temp"

mkdir $tempmap -ErrorAction SilentlyContinue 1>$null
Remove-Item "$tempmap\*" -Recurse -Force 

# uitpakken van programma naar tempmap. alleen de updater is nu nodig.
Expand-Archive -Path "$zip_download" -DestinationPath "$tempmap" -Force

# zipbestand na het uitpakken direct verwijderen
Remove-Item "$zip_download"

# updater wordt nu geupdated

# kopiren updater en foutmeldingen opvangen
$error.clear()
try {
    Copy-Item -path "$tempmap\$updater" -destination "$startmap" -ErrorAction Stop
    }
catch {
    
    if ($opgestart -eq "keuzemenu")  { 
        $null = [System.Windows.Forms.MessageBox]::Show("Fout tijdens het updaten.  Het bestand " + $updater + " is niet gepdatet. 
        
Het updateproces wordt gestopt." , "Fout tijdens updaten",  "OK" , "Stop") 
        } else {
        $opstartinfo.text = "Fout tijdens het updaten. Het bestand " + $updater + " is niet gepdatet."
        Start-Sleep -s 3
        }
    return
    }


# buttons sluiten. Anders krijg je een foutmelding bij script updater bij het kopieren van de map "png".
# de png-bestanden blijven namelijk nog in gebruik door powershell en de melding "icoon-backup.png is in use" verschijnt.
$Button1.Image.Dispose()
$Button2.Image.Dispose()
$Button3.Image.Dispose()
$Button4.Image.Dispose()
# $Button5.Image.Dispose()
$Button6.Image.Dispose()
$Button7.Image.Dispose()
$Button8.Image.Dispose()
$Button9.Image.Dispose()
$Button10.Image.Dispose()
$Button11.Image.Dispose()

# vensters sluiten

$form.Dispose()
$Form_opstart.dispose()

# opstarten updater
& "$PSScriptRoot\$updater"

# beindigen van programma als updaten in het begin is opgestart
if ($opgestart -eq "begin") {
    exit;
    } 

}

function vensterinstellingen {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# variabelen
$keuzelocatie=$global:init["algemeen"]["locatiekeuze"]

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(600,400)
$form2.text                       = "Instellingen wijzigen"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$uitleg_instellingen                     = New-Object system.Windows.Forms.Label
$uitleg_instellingen.text                = "Wijzig hier de standaard instellingen van het programma.
Klik op Bewaren om de instellingen te bewaren en terug te gaan 
of op Annuleren om terug te gaan zonder op te slaan."
$uitleg_instellingen.AutoSize            = $false
$uitleg_instellingen.width               = 580
$uitleg_instellingen.height              = 70
$uitleg_instellingen.location            = New-Object System.Drawing.Point(20,15)
$uitleg_instellingen.Font                = 'Microsoft Sans Serif,12'
$uitleg_instellingen.ForeColor = [System.Drawing.Color]::Blue

$keuzeoptie1                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie1.width               = 80
$keuzeoptie1.autosize            = $true
$keuzeoptie1.DropDownStyle       = "DropDownList"
$keuzeoptie1.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie1.location = "450,80" 

# locaties toevoegen aan lijst
$teller=0
$global:locaties.keys | ForEach-Object {
    # locatiecode toevoegen
    [void] $keuzeoptie1.Items.Add("$_")

    # standaard keuzelocatie selecteren en in index van lijst zetten
    if ($_ -eq "$keuzelocatie") { $keuzeoptie1.Selectedindex = $teller }
    $teller++
    }

$keuzeoptie2                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie2.width               = 80
$keuzeoptie2.autosize            = $true
$keuzeoptie2.DropDownStyle       = "DropDownList"
$keuzeoptie2.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie2.location = "450,120" 
[void] $keuzeoptie2.Items.Add("Ja")
[void] $keuzeoptie2.Items.Add("Nee")
if ($global:init["algemeen"]["wissennabackup"] -eq "ja") {
    $keuzeoptie2.Selectedindex = 0
    } else {
    $keuzeoptie2.Selectedindex = 1
    }

$keuzeoptie3                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie3.width               = 80
$keuzeoptie3.autosize            = $true
$keuzeoptie3.DropDownStyle       = "DropDownList"
$keuzeoptie3.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie3.location = "450,160" 
[void] $keuzeoptie3.Items.Add("Ja")
[void] $keuzeoptie3.Items.Add("Nee")
if ($global:init["algemeen"]["maplegenvoorverplaatsen"] -eq "ja") {
    $keuzeoptie3.Selectedindex = 0
    } else {
    $keuzeoptie3.Selectedindex = 1
    }

$keuzeoptie4                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie4.width               = 80
$keuzeoptie4.autosize            = $true
$keuzeoptie4.DropDownStyle       = "DropDownList"
$keuzeoptie4.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie4.location = "450,200" 
[void] $keuzeoptie4.Items.Add("Ja")
[void] $keuzeoptie4.Items.Add("Nee")
if ($global:init["algemeen"]["autoupdate"] -eq "ja") {
    $keuzeoptie4.Selectedindex = 0
    } else {
    $keuzeoptie4.Selectedindex = 1
    }
$keuzeoptie4.add_SelectedIndexChanged({
    if ($keuzeoptie4.Selectedindex -eq 0) {
    $keuzeoptie5.enabled = $false
    $Description5.ForeColor = [System.Drawing.Color]::gray
    }
        else {
    $keuzeoptie5.enabled = $true
    $Description5.ForeColor = [System.Drawing.Color]::Blue
    }
})

$keuzeoptie5                     = New-Object system.Windows.Forms.ComboBox
$keuzeoptie5.width               = 80
$keuzeoptie5.autosize            = $true
$keuzeoptie5.DropDownStyle       = "DropDownList"
$keuzeoptie5.Font                = 'Microsoft Sans Serif,12'
$keuzeoptie5.location = "450,240" 
[void] $keuzeoptie5.Items.Add("Ja")
[void] $keuzeoptie5.Items.Add("Nee")
if ($global:init["algemeen"]["updatenotificatie"] -eq "ja") {
    $keuzeoptie5.Selectedindex = 0
    } else {
    $keuzeoptie5.Selectedindex = 1
    }
if ($global:init["algemeen"]["autoupdate"] -eq "ja") {
    $keuzeoptie5.enabled = $false
    } 

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Standaard locatie"
$Description1.AutoSize            = $false
$Description1.width               = 400
$Description1.height              = 30
$Description1.location            = New-Object System.Drawing.Point(40,80)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Studentmappen wissen na uitvoeren van een backup"
$Description2.AutoSize            = $false
$Description2.width               = 400
$Description2.height              = 30
$Description2.location            = New-Object System.Drawing.Point(40,120)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Studentmap wissen voor het verplaatsen van bestanden"
$Description3.AutoSize            = $false
$Description3.width               = 400
$Description3.height              = 30
$Description3.location            = New-Object System.Drawing.Point(40,160)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "Automatisch updaten bij de start van het programma"
$Description4.AutoSize            = $false
$Description4.width               = 400
$Description4.height              = 30
$Description4.location            = New-Object System.Drawing.Point(40,200)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::Blue

$Description5                     = New-Object system.Windows.Forms.Label
$Description5.text                = "Melding geven wanneer een update beschikbaar is"
$Description5.AutoSize            = $false
$Description5.width               = 400
$Description5.height              = 30
$Description5.location            = New-Object System.Drawing.Point(40,240)
$Description5.Font                = 'Microsoft Sans Serif,11'
# kleur bepalen afhankelijk van of deze enabled is of niet
if ($keuzeoptie4.Selectedindex -eq 0) {
    $Description5.ForeColor = [System.Drawing.Color]::gray
    }
        else {
    $Description5.ForeColor = [System.Drawing.Color]::Blue
    }

$Btnstandaard = New-object System.Windows.Forms.Button 
$Btnstandaard.text= "Herstel de standaardinstellingen"
$Btnstandaard.location = "50,300" 
$Btnstandaard.size = "250,30"  
$Btnstandaard.BackColor = 'blue'
$Btnstandaard.ForeColor = 'white'
$Btnstandaard.add_click({
    # inlezen ini-bestand naar tijdelijke object
    $temp_init = standaardinstellingen

    # alle opties krijgen hun standaard waarde. Er wordt nog niets bewaard!
    
    # keuzeoptie 1
    $keuzeoptie1.SelectedItem=$temp_init["algemeen"]["locatiekeuze"]

    # keuzeoptie 2 tm 5.
    if ($temp_init["algemeen"]["wissennabackup"] -eq "ja") {
    $keuzeoptie2.Selectedindex = 0
    } else {
    $keuzeoptie2.Selectedindex = 1
    }

    if ($temp_init["algemeen"]["maplegenvoorverplaatsen"] -eq "ja") {
    $keuzeoptie3.Selectedindex = 0
    } else {
    $keuzeoptie3.Selectedindex = 1
    }

    if ($temp_init["algemeen"]["autoupdate"] -eq "ja") {
    $keuzeoptie4.Selectedindex = 0
    $keuzeoptie5.enabled = $false
    $Description5.ForeColor = [System.Drawing.Color]::gray
    } else {
    $keuzeoptie4.Selectedindex = 1
    $keuzeoptie5.enabled = $true
    $Description5.ForeColor = [System.Drawing.Color]::Blue
    }

    if ($temp_init["algemeen"]["updatenotificatie"] -eq "ja") {
    $keuzeoptie5.Selectedindex = 0
    } else {
    $keuzeoptie5.Selectedindex = 1
    }
}) # einde Btnstandaard.add_click

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bewaren"
$Btnaccept.location = "50,350" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.DialogResult = [System.Windows.Forms.DialogResult]::yes

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,350" 
$Btnescape.size = "150,30"  
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$Form2.Controls.AddRange(@($keuzeoptie1, $keuzeoptie2, $keuzeoptie3, $keuzeoptie4, $keuzeoptie5, $description1, $description2, $description3, $description4, $description5, $uitleg_instellingen, $Btnstandaard, $Btnaccept, $Btnescape ))

# openen venster
$result = $form2.ShowDialog()

# bewaren van instellingen
if ($result -eq [system.windows.forms.dialogResult]::yes) { 

    # keuzes worden ingesteld
    $global:init["algemeen"]["locatiekeuze"]=$keuzeoptie1.Selecteditem

    if ($keuzeoptie2.Selectedindex -eq 0) {
        $global:init["algemeen"]["wissennabackup"]="ja"
        } else {
        $global:init["algemeen"]["wissennabackup"]="nee"
        } 
    if ($keuzeoptie3.Selectedindex -eq 0) {
        $global:init["algemeen"]["maplegenvoorverplaatsen"]="ja"
        } else {
        $global:init["algemeen"]["maplegenvoorverplaatsen"]="nee"
        }
    if ($keuzeoptie4.Selectedindex -eq 0) {
        $global:init["algemeen"]["autoupdate"]="ja"
        } else {
        $global:init["algemeen"]["autoupdate"]="nee"
        }
    if ($keuzeoptie5.Selectedindex -eq 0) {
        $global:init["algemeen"]["updatenotificatie"]="ja"
        } else {
        $global:init["algemeen"]["updatenotificatie"]="nee"
        }
    # bestand met nieuwe variabele bewaren
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand

} # einde bewaren van instellingen

# De hoofdmenu zichtbaar maken
$form.show()

}

function uitvoerenopschonen {

# controle of geldige invoer is gegeven
if (($uitvoerenbackups.Checked) -and ($objTextBox1.Text -eq "" )) {
    $null = vraagvenster "Geen geldige getal ingevuld" "Vul een geldige getal in voor het aantal dagen verwijderen backups." "OK"
    return;
}

if (($uitvoerenlogbestanden.Checked) -and ($objTextBox2.Text -eq "" )) {
    $null = vraagvenster "Geen geldige getal ingevuld" "Vul een geldige getal in voor het aantal dagen verwijderen logbestanden" "OK"
    return;
}

# mappen controleren of deze bestaan
# eerst de backupmap
if ($uitvoerenbackups.Checked) {
    if (!(test-path -path "$backupmap")) {
    $null = vraagvenster "Map bestaat niet" "De backup-map is niet gevonden!

Controleer of de volgende map aanwezig is :
$backupmap
De taak kan nu niet opgestart worden." "OK"
    return;
    }
}
# dan de logmap
if ($uitvoerenlogbestanden.Checked) {
    if (!(test-path -path "$logmap")) {
    $null = vraagvenster "Map bestaat niet" "De log-map is niet gevonden!
Controleer of de volgende map aanwezig is :

$logmap

De taak kan nu niet opgestart worden." "OK"
    return;
    }
}

# ingevoerde getallen uit de invulboxen halen en eventueel de nullen ervoor eruit halen. dit laatste is een controle.
# getal1 is voor de backups en getal2 voor de logbestanden
[int32]$getal1=$objTextBox1.Text
[int32]$getal2=$objTextBox2.Text

# aantal backups en logbestanden die worden verwijderd tellen
$tellerlogs=0
$tellerbackups=0

if ($uitvoerenbackups.Checked) {
    # deze get-childitem is dezelfde als onder bij het daadwerkelijk uitvoeren
    Get-ChildItem -Path "$backupmap" | Where-Object {($_.psiscontainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal1))} | foreach-object {
        $tellerbackups++
        }
    }
if ($uitvoerenlogbestanden.Checked) {
    Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        $tellerlogs++
        }
    }

# aantallen zijn geteld en als beiden nul zijn kan je niet verder
if (( $tellerlogs -eq 0) -and ($tellerbackups -eq 0)) {
    $null = vraagvenster 'Geen bestanden om te verwijderen' "
Met de huidige instellingen worden er geen backups of logbestanden verwijderd!
Maak opnieuw een keuze als dit niet klopt of Annuleer het opschonen als dit wel klopt." 'Ok'
    return;
}
 
# aantallen bij elkaar optellen voor de progressbar
$ProgressBar.maximum = $tellerlogs + $tellerbackups

# bepalen tekst om weer te geven in vraag om opschonen
if (($uitvoerenbackups.Checked) -and ($uitvoerenlogbestanden.Checked)) {
    $vraagopschonen="De volgende keuzes zijn gemaakt:

Er worden $tellerbackups Backups ouder dan $getal1 dagen en
$tellerlogs Logbestanden ouder dan $getal2 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    } elseif (($uitvoerenbackups.Checked) -and (!($uitvoerenlogbestanden.Checked)) ) {
    $vraagopschonen="De volgende keuze is gemaakt:

Er worden $tellerbackups Backups ouder dan $getal1 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    } else {
    $vraagopschonen="De volgende keuze is gemaakt:

Er worden $tellerlogs Logbestanden ouder dan $getal2 dagen verwijderd.

Klik op Doorgaan als dit juist is."
    }

$result=vraagvenster "Overzicht van de gemaakte keuzes" $vraagopschonen "Doorgaan" "Annuleren"

if ( $result -eq "Cancel") { return }

$vraagopschonen=" LET OP : Als u nu op Opschonen klikt worden de bestanden definitief verwijderd!

Dit kan niet worden teruggedraaid.

Klik op Annuleren als u terug wilt.
"
$result=vraagvenster "Starten met opschonen?" $vraagopschonen "Opschonen" "Annuleren"

if ( $result -eq "Cancel") { return }

# start proces verwijderen

# koppen onzichtbaar maken
$btnaccept.hide()
$btnescape.hide()

# tekst weergeven dat de taak gestart is
$uitleg_opschonen.ForeColor = 'red'
$uitleg_opschonen.Text = "Opschonen wordt uitgevoerd ..."

# progressbar zichtbaar maken
$progressBar.Visible=$true

# datum bepalen
$datumvandaag = bepaaldatum;

# logbestandsnaam definiren en volledige pad naar bestand invoeren
# $logbestand = -join ("$logmap","\log_","$datumvandaag",".txt")
$logbestand = bepaallognaam "$datumvandaag"

# starttijd van loggen naar variabele
$logtijd = get-date -Format "HH:mm:ss"

#foutmelding voor logbestand
$foutmelding_log="[ FOUT ] "
$foutmelding = $false

# in logbestand schrijven
"Het opschonen van bestanden is uitgevoerd." | out-file $logbestand -Append
"Starttijd : $logtijd" | out-file $logbestand -Append

# verwijderen oude backups
if ($uitvoerenbackups.Checked) {
    # in logbestand info schrijven
    "De volgende backupmappen ouder dan $getal1 dagen verwijderen : " | out-file $logbestand -Append

    # bepaal de lijst met mappen die verwijderd worden
    Get-ChildItem -Path "$backupmap" | Where-Object {($_.psiscontainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal1))} | foreach-object {
        # map om te verwijderen
        $todelete = $_
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append
        # stap nemen in progressbar
        $ProgressBar.PerformStep()
        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()
        try {
            Remove-Item "$backupmap\$todelete" -recurse -force -ErrorAction Stop
            }
        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
            $foutmelding = $true
              } # einde try catch
    } # einde get-childitem
    } # einde if $uitvoerenbackups.Checked

# verwijderen oude logs
if ($uitvoerenlogbestanden.Checked) {
    # in logbestand info schrijven
    "De volgende logbestanden ouder dan $getal2 dagen verwijderen : " | out-file $logbestand -Append

    # bepaal de lijst met mappen die verwijderd worden
    Get-ChildItem -Path "$logmap" | Where-Object {(!($_.psiscontainer) -and $_.LastWriteTime -lt (Get-Date).AddDays(-$getal2))} | foreach-object {
        # map om te verwijderen
        $todelete = $_
        # in logbestand schrijven
        " - $todelete " | out-file $logbestand -Append
        # stap nemen in progressbar
        $ProgressBar.PerformStep()
        Start-Sleep -s 1
        #verwijderen map en opvangen foutmelding met try- catch methode
        $error.clear()
        try {
            Remove-Item "$logmap\$todelete" -force -ErrorAction Stop 
            }
        catch {
            # foutmelding van PowerShell naar logbestand
            "$foutmelding_log" + $_ | out-file $logbestand -Append
            $foutmelding = $true
              } # einde try catch
    } # einde get-childitem

    } # einde if $uitvoerenlogbestanden.Checked

# in logbestand eindtijd schrijven
# eerst eindtijd naar variabele
$logtijd = get-date -Format "HH:mm:ss"

"" | out-file $logbestand -Append
"Eindtijd  : $logtijd" | out-file $logbestand -Append
" -------------------------------------------------------------------------" | out-file $logbestand -Append
"" | out-file $logbestand -Append


# de log-knop zichtbaar maken en start-knop onzichtbaar
$LogButton.show()
$Btnescape.text= "Terug"
$Btnescape.BackColor = 'blue'
$btnescape.show()

# aangeven dat taken zijn uitgevoerd 
if ($foutmelding) { $uitleg_opschonen.Text = "Het opschonen is niet correct uitgevoerd. Bekijk de foutmeldingen in het logbestand."
    } else { $uitleg_opschonen.Text = "Opschonen is uitgevoerd." }
}

function vensteropschonen {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(650,400)
$form2.text                       = "Opschonen backups en logbestanden"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$uitleg_opschonen                     = New-Object system.Windows.Forms.Label
$uitleg_opschonen.text                = "Verwijder oude backups van de studentmappen en/of oude logbestanden.
Maak een keuze door het betreffende vakje aan te vinken.
Wijzigen eventueel vanaf hoeveel dagen oud de bestanden verwijderd worden."
$uitleg_opschonen.AutoSize            = $false
$uitleg_opschonen.width               = 580
$uitleg_opschonen.height              = 80
$uitleg_opschonen.location            = New-Object System.Drawing.Point(20,15)
$uitleg_opschonen.Font                = 'Microsoft Sans Serif,12'
$uitleg_opschonen.ForeColor = [System.Drawing.Color]::Blue

$uitvoerenbackups = New-Object System.Windows.Forms.Checkbox 
$uitvoerenbackups.Location = New-Object System.Drawing.Point(20,80)
$uitvoerenbackups.Size = New-Object System.Drawing.Size(500,30)
$uitvoerenbackups.Text = "Verwijder backups van de studentmappen."
$uitvoerenbackups.Font = 'Microsoft Sans Serif,12'
$uitvoerenbackups.ForeColor = [System.Drawing.Color]::Green
$uitvoerenbackups.add_click( {
     if ($uitvoerenbackups.Checked) {
        $Description1.Show()
        $Description3.Show()
        $objTextBox1.Show()
        $Btnaccept.Enabled=$true
        } else {
        $Description1.hide()
        $Description3.hide()
        $objTextBox1.Hide()
        if (!($uitvoerenlogbestanden.Checked)) { $Btnaccept.Enabled=$false }
        }
     } )

$uitvoerenlogbestanden = New-Object System.Windows.Forms.Checkbox 
$uitvoerenlogbestanden.Location = New-Object System.Drawing.Point(20,130)
$uitvoerenlogbestanden.Size = New-Object System.Drawing.Size(500,30)
$uitvoerenlogbestanden.Text = "Verwijder logbestanden van het programma."
$uitvoerenlogbestanden.Font = 'Microsoft Sans Serif,12'
$uitvoerenlogbestanden.ForeColor = [System.Drawing.Color]::Green
$uitvoerenlogbestanden.add_click( {
     if ($uitvoerenlogbestanden.Checked) {
        $Description2.Show()
        $Description4.Show()
        $objTextBox2.Show()
        $Btnaccept.Enabled=$true
        } else {
        $Description2.hide()
        $Description4.hide()
        $objTextBox2.Hide()
        if (!($uitvoerenbackups.Checked)) { $Btnaccept.Enabled=$false }
        }
     } )

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Backups van de studentmappen die ouder zijn dan"
$Description1.AutoSize            = $false
$Description1.width               = 360
$Description1.height              = 40
$Description1.location            = New-Object System.Drawing.Point(20,182)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::blue
$Description1.hide()

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Logbestanden van het programma die ouder zijn dan"
$Description2.AutoSize            = $false
$Description2.width               = 360
$Description2.height              = 40
$Description2.location            = New-Object System.Drawing.Point(20,232)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::blue
$Description2.hide()

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "dagen worden verwijderd."
$Description3.AutoSize            = $false
$Description3.width               = 200
$Description3.height              = 40
$Description3.location            = New-Object System.Drawing.Point(440,182)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::blue
$Description3.hide()

$Description4                     = New-Object system.Windows.Forms.Label
$Description4.text                = "dagen worden verwijderd."
$Description4.AutoSize            = $false
$Description4.width               = 200
$Description4.height              = 40
$Description4.location            = New-Object System.Drawing.Point(440,232)
$Description4.Font                = 'Microsoft Sans Serif,11'
$Description4.ForeColor = [System.Drawing.Color]::blue
$Description4.hide()

$objTextBox1 = New-Object System.Windows.Forms.TextBox 
$objTextBox1.Location = New-Object System.Drawing.Size(380,180) 
$objTextBox1.Size = New-Object System.Drawing.Size(55,50)
$objTextBox1.MaxLength = 4
$objTextBox1.Font = 'Microsoft Sans Serif,11'
$objTextBox1.Hide()
$objTextBox1.Text=$Global:init["opschonen"]["dagenbewarenbackup"]
$objTextBox1.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})


$objTextBox2 = New-Object System.Windows.Forms.TextBox 
$objTextBox2.Location = New-Object System.Drawing.Size(380,230) 
$objTextBox2.Size = New-Object System.Drawing.Size(55,50)
$objTextBox2.MaxLength = 4
$objTextBox2.Font = 'Microsoft Sans Serif,11'
$objTextBox2.Hide()
$objTextBox2.Text=$Global:init["opschonen"]["dagenbewarenlogs"]
$objTextBox2.Add_TextChanged({
    $this.Text = $this.Text -replace '\D'
})

$Btnaccept = New-object System.Windows.Forms.Button 
$Btnaccept.text= "Bevestigen"
$Btnaccept.location = "50,350" 
$Btnaccept.size = "150,30"  
$Btnaccept.BackColor = 'green'
$Btnaccept.ForeColor = 'white'
$Btnaccept.add_click({ 
    uitvoerenopschonen
    })
$Btnaccept.Enabled=$false

$Btnescape = New-object System.Windows.Forms.Button 
$Btnescape.text= "Annuleren"
$Btnescape.location = "250,350" 
$Btnescape.size = "150,30"
$Btnescape.BackColor = 'red'
$Btnescape.ForeColor = 'white'
$Btnescape.DialogResult = [System.Windows.Forms.DialogResult]::cancel

$LogButton = New-Object System.Windows.Forms.Button
$LogButton.Location = New-Object System.Drawing.Size(50, 350)
$LogButton.Size = New-Object System.Drawing.Size(150, 30)
$LogButton.Text = "Logbestand bekijken"
#$LogButton.height = 40
$LogButton.BackColor = 'blue'
$LogButton.ForeColor = 'white'
$LogButton.hide()
$LogButton.add_click({ 
    $Form2.close()
    vensterlogbestand })


# het proces zichtbaar maken in een balk
$ProgressBar = New-Object System.Windows.Forms.ProgressBar
$ProgressBar.Location = New-Object System.Drawing.Point(20, 280)
$ProgressBar.Size = New-Object System.Drawing.Size(600, 40)
$ProgressBar.Style = "continuous"
$ProgressBar.step = 1
$progressBar.Visible=$false

$Form2.Controls.AddRange(@($uitvoerenbackups, $uitvoerenlogbestanden, $description1, $description2, $Description3, $Description4, $objTextBox1, $objTextBox2, $uitleg_opschonen, $Btnaccept, $Btnescape, $LogButton, $ProgressBar ))

# openen venster
$null = $form2.ShowDialog()

# De hoofdmenu zichtbaar maken
$form.show()

} 

function info_venster_vullen ($keuze) {

# infovenster en tijdelijke object legen
$objtekst1.Text = "Het bestand wordt geladen ..."
$objtekst_temp.text = ""

# inhoud bestand inlezen
if ($keuze -eq "readme") { 
    $volledigetext = Get-Content -Path "$tempreadmebestand"
    } else {
    $volledigetext = Get-Content -Path "$tempchangelogbestand"
    }

# dan netjes in rijen plaatsen.
foreach ($item in $volledigetext) {
               $objtekst_temp.Text = $objtekst_temp.Text + "$item" + "`r`n"
               }

$objtekst1.Text = $objtekst_temp.text 
}

function informatieprogramma {

# De hoofdmenu onzichtbaar maken
$form.Hide()

# datum wanneer programma laatst is gewijzigd. Wordt niet meer getoond!
# $lastModifiedDate = (Get-Item "$startmap\beherenbestanden.ps1").LastWriteTime

# aangeven wat de inhoud is van de infovenster, readme of changelog
$global:infovenster = "readme"

# venster declareren
$form2                            = New-Object system.Windows.Forms.Form
$form2.ClientSize                 = New-Object System.Drawing.Point(950,650)
$form2.text                       = "Informatie over het programma"
$form2.TopMost                    = $false
$form2.StartPosition              = 'CenterScreen'

$Description1                     = New-Object system.Windows.Forms.Label
$Description1.text                = "Hieronder ziet u belangrijke informatie over dit programma.
In het vakje kunt u eventueel de readme- of de changelog-bestand bekijken.
Door op de betreffene knop te klikken wijzigt u de inhoud."
$Description1.AutoSize            = $false
$Description1.width               = 770
$Description1.height              = 50
$Description1.location            = New-Object System.Drawing.Point(20,15)
$Description1.Font                = 'Microsoft Sans Serif,11'
$Description1.ForeColor = [System.Drawing.Color]::Blue

$Description2                     = New-Object system.Windows.Forms.Label
$Description2.text                = "Naam van het programma :
Versie : 
Build :
Hoofd progammeur :"

$Description2.AutoSize            = $false
$Description2.width               = 300
$Description2.height              = 100
$Description2.location            = New-Object System.Drawing.Point(20,80)
$Description2.Font                = 'Microsoft Sans Serif,11'
$Description2.ForeColor = [System.Drawing.Color]::Blue

$Description3                     = New-Object system.Windows.Forms.Label
$Description3.text                = "Beherenbestanden
$global:versie
$extralabel
Benvindo Neves"

$Description3.AutoSize            = $false
$Description3.width               = 200
$Description3.height              = 100
$Description3.location            = New-Object System.Drawing.Point(330,80)
$Description3.Font                = 'Microsoft Sans Serif,11'
$Description3.ForeColor = [System.Drawing.Color]::Blue


$Btninfovenster = New-object System.Windows.Forms.Button 
$Btninfovenster.text= "Changelog bekijken"
$Btninfovenster.location = "230,600" 
$Btninfovenster.size = "180,30"  
$Btninfovenster.BackColor = 'blue'
$Btninfovenster.ForeColor = 'white'
$Btninfovenster.add_click({ 
    if ($global:infovenster -eq "readme") { 
        $global:infovenster="changelog" 
        $Btninfovenster.text= "Readme bekijken"
        } else { 
        $global:infovenster="readme" 
        $Btninfovenster.text= "Changelog bekijken"
        } 
    # infovenster vullen met infobestand
    info_venster_vullen $global:infovenster
})


$Buttenok = New-object System.Windows.Forms.Button 
$Buttenok.text= "Sluiten"
$Buttenok.location = "50,600" 
$Buttenok.size = "150,30"  
$Buttenok.BackColor = 'blue'
$Buttenok.ForeColor = 'white'
$Buttenok.DialogResult = [System.Windows.Forms.DialogResult]::ok

$objtekst1 = New-Object System.Windows.Forms.textbox
$objtekst1.Location = New-Object System.Drawing.Size(20,180) 
$objtekst1.Size = New-Object System.Drawing.Size(920,410)
$objtekst1.font = New-Object System.Drawing.Font('Microsoft Sans Serif',12)
$objtekst1.Text = ""
$objtekst1.ReadOnly = $true
$objtekst1.Multiline = $true
$objtekst1.ScrollBars = "Both"

# dit object maakt dat het laden van het bestand en laten zien in het venster sneller gaat
# zie ook function info_venster_vullen
$objtekst_temp = New-Object System.Windows.Forms.textbox

$Form2.Controls.AddRange(@($Description1, $Description2, $Description3, $Buttenok, $Btninfovenster, $objtekst1))


# tijdelijke bestanden benoemen
$tempreadmebestand="$startmap\temp_$readmebestand"
$tempchangelogbestand="$startmap\temp_$changelogbestand"

# downloaden readmebestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$readmebestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempreadmebestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen readme gevonden" "Het is niet gelukt om het readme-bestand te downloaden." "Sluiten" 
    "Het readme-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempreadmebestand"
}
# downloaden changelogbestand en foutmeldingen opvangen
$error.clear()
$downloadbestand = -join ("$updatewebsite","/","$changelogbestand")
try {
    Invoke-WebRequest "$downloadbestand" -outfile "$tempchangelogbestand" -ErrorAction Stop
    }
catch {
    vraagvenster "Geen changelog gevonden" "Het is niet gelukt om het changelog-bestand te downloaden." "Sluiten" 
    "Het changelog-bestand is niet gedownload en kan dus niet getoont worden." | Out-File "$tempchangelogbestand"
}

# infovenster vullen met infobestand
info_venster_vullen $global:infovenster

# venster starten
$null = $form2.ShowDialog()

# temp bestanden verwijderen
Remove-Item "$tempreadmebestand" -force
Remove-Item "$tempchangelogbestand" -force

# De hoofdmenu zichtbaar maken
$form.show()
}

# initialiseren van programma ---------------------------------------------------------------

# controleren of initialisatie-bestand aanwezig is en inlezen bestand, anders bestand aanmaken

$opstartinfo.text = "Initialiseren ..."

# oude initialisatiebestand inlezen en omzetten
# dit kan verwijderd worden als iedereen minimaal versie 4.2.2 heeft.
$init_oud = "gebruiker.ini"

if (test-path -path $init_oud -pathtype leaf) { 
# inlezen oude ini-bestand naar object
$myobject = Get-IniContent $init_oud

# bewaren als hashwaarden in nieuwe initbestand
$myobject | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand

# verwijderen oude init
Remove-Item -Path $init_oud
}

# standaard instellingen bepalen voor object $init
$global:init = standaardinstellingen

# inlezen initialisatiebestand als deze bestaat en toevoegen of verwijderen waarden van $init
# dit is nodig zodat, als de initialisatiebestand wordt ingelezen, eventuele nieuwe variabelen worden behouden en verwijderde variabelen niet worden toegevoegd. 
if (test-path -path $global:initbestand -pathtype leaf) { 
    # inlezen van object als hashwaarden. hier staan de gewijzigde waarden in die je wil behouden.
    $myObject = Get-Content -Path $global:initbestand | ConvertFrom-Json

    # waarden overzetten naar $init. nieuwe waarden worden behouden. verwijderde waarden worden niet toegevoegd.
    foreach( $property in $myobject.psobject.properties.name ) {
        foreach( $subproperty in $myobject.$property.psobject.properties.name )
        {
        # alleen toevoegen als deze bij 'init' al bestaat
        if ( $global:init.$property.$subproperty -ne $null) { 
            $global:init[$property][$subproperty] = $myObject.$property.$subproperty 
            }
        } # einde foreach $subproperty - loop 
        } # einde foreach $property - loop    

    # gekozen is om dit altijd te bewaren zodat je lijst met variabelen up to date is.
    $global:init | ConvertTo-Json -depth 1 | Set-Content -Path $global:initbestand    
    } 

<# verwijderen oude initialisatiebestand als deze bestaat
   dit kan op een gegeven moment als iedereen up to date is, verwijderd worden.
   vanaf versie 4.2.1 wordt config.ini niet meer gebruikt.
   eerst oude initbestand bepalen
#>
$oudeinit = -join ("$startmap","\","config.ini")
if (test-path -path $oudeinit -pathtype leaf) { 
    Remove-Item -Path $oudeinit -force
}

# einde intialiseren programma

# controleren op een update. alleen als hiervoor al geen update is uitgevoerd.

updatevoorbereiden ("begin");

# opstart venster sluiten voor het tonen van hoofdvenster
Start-Sleep -s 2
$Form_opstart.dispose()

# Form wordt getoond. dit is de hoofdvenster
$null = $Form.ShowDialog()
