﻿# Dit is de "Programma updater" voor "Beherenbestanden.ps1"

# declareren variabelen ------------------------------------------------------------------------------------

# startmap van het programma
$startmap=Split-Path -Parent $PSCommandPath

# info uit updateinfo halen om te updaten en variabelen bepalen.

# pad naar updateinfo op lokale pc
$updateinfobestand = -join ("$startmap","\","$global:updateinfo")

# huidige versie wordt alleen in updater.ps1 gebruikt.  dit maakt het duidelijker en je hoeft niet bij elke versie "global" voor te zetten.
$huidigeversie = $global:versie

# updaten naar een versie. "uptodate" betekent geen update nodig, 
$updateto="uptodate"

# tempmap met gedownloade bestanden. Dit is ook bij beherenbestanden.ps1 gedeclareerd.
# een wijziging daar moet hier worden doorgevoerd.
$tempmap = "$startmap\temp"

# Form_update declareren en weergeven ----------------------------------------------------------------------
$Form_update                            = New-Object system.Windows.Forms.Form
$Form_update.ClientSize                 = New-Object System.Drawing.Point(450,180)
$Form_update.text                       = "Updater voor programma Beheren bestanden"
$Form_update.TopMost                    = $false
$Form_update.StartPosition              = 'CenterScreen'

$updatekoptekst                     = New-Object system.Windows.Forms.Label
$updatekoptekst.text                = "Programma wordt geupdated ..."
$updatekoptekst.AutoSize            = $false
$updatekoptekst.width               = 300
$updatekoptekst.height              = 30
$updatekoptekst.location            = New-Object System.Drawing.Point(20,15)
$updatekoptekst.Font                = 'Microsoft Sans Serif,12'
$updatekoptekst.ForeColor = [System.Drawing.Color]::Blue
$Form_update.Controls.Add($updatekoptekst)

# hiermee kan extra informatie worden gegeven. bv bij een foutmelding
$updateinfotekst                     = New-Object system.Windows.Forms.Label
$updateinfotekst.text                = ""
$updateinfotekst.AutoSize            = $false
$updateinfotekst.width               = 400
$updateinfotekst.height              = 100
$updateinfotekst.location            = New-Object System.Drawing.Point(20,50)
$updateinfotekst.Font                = 'Microsoft Sans Serif,12'
$updateinfotekst.ForeColor = [System.Drawing.Color]::Blue
# Dit is uitgeschakeld omdat het nog nietgebruikt wordt.
# $Form_update.Controls.Add($updateinfotekst)

# functies ---------------------------------------------------

function Get-IniContent ($filePath)
{
    $ini = @{}
    switch -regex -file $FilePath
    {
        “^\[(.+)\]” # Section
        {
            $section = $matches[1]
            $ini[$section] = @{}
            $CommentCount = 0
        }
        “^(;.*)$” # Comment
        {
            $value = $matches[1]
            $CommentCount = $CommentCount + 1
            $name = “Comment” + $CommentCount
            $ini[$section][$name] = $value
        }
        “(.+?)\s*=(.*)” # Key
        {
            $name,$value = $matches[1..2]
            $ini[$section][$name] = $value
        }
    }
    return $ini
}

# start programma ----------------------------------------------------------

# weergeven Form_update
$Form_update.Show()

# bepalen update versie

# inlezen ini-bestand naar object
$updaterini = Get-IniContent $updateinfobestand


# controleren op revisie en anders op laatste versie 
if ($updaterini["revision"].Contains($huidigeversie) ) {
    $updateto = $updaterini["revision"]["$huidigeversie"]
    } else {
    
    if ("$huidigeversie" -lt $updaterini["program"]["latest"]) {
        $updateto = $updaterini["program"]["latest"]
        }
} 


# einde bepalen update versie. er is bepaald of er een update is.

# beveiliging mocht iets mis zijn met updateinfo-bestand
if (!($updateto -eq "uptodate") ) {

<# kopiëren programma en onderdelen en foutmeldingen opvangen
   de updater in de tempmap wordt verwijderen. deze wordt dan niet weer gekopiëerd
   dit is nodig zodat daarna alles in de tempmap gekopieerd kan worden en bij eventuele nieuwe bestanden geen extra werk of foutmeldingen komen.
   anders moet je een verschil maken tussen "versies met" en "versies zonder" een nieuwe bestand.
#>
    Remove-Item "$tempmap\$updater" -Force
    Copy-Item -path "$tempmap\*" -destination "$startmap" -force -ErrorAction Stop
    Copy-Item -path "$tempmap\png\*" -destination "$startmap\png" -force -ErrorAction Stop

#schoonmaken temp map
Remove-Item "$tempmap" -Force -Recurse

# bewerkingen na de update -------------------------------------------

if ($updaterini.Contains($updateto) ) {

" updateversie in init ************************"

if ($updaterini["$updateto"].contains("remove-files") ) { $remfiles = $updaterini["$updateto"]["remove-files"] }
if ($updaterini["$updateto"].contains("remove-init") ) { $reminit  = $updaterini["$updateto"]["remove-init"] }

if ( ($remfiles) -and ($updaterini.Contains($remfiles) ) ) { 

" remove-files in updaterini ************************"
foreach ($item in $updaterini["$remfiles"].values ) { 
    Write-Host $item
    }

} # einde verwijderen files

Write-Host " - reminit : " $reminit

if ("$reminit" -eq "true") {
# verwijderen initialisatie beheren.ini
write-host " verwijderen initialisatie beheren.ini ************************"
}

} # einde bewerkingen na de update

} else {
  # geef foutemelding met venster
} # einde beveiliging mocht iets mis zijn met updateinfo-bestand .. else ..

Start-Sleep -s 3

# sluiten updater
$Form_update.dispose()

# opstarten hoofdprogramma
& "$PSScriptRoot\beherenbestanden.ps1"